/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.java.resolve.JavaType;

public class TypeSubstitution {
    private Map<JavaType.TypeVariableJavaType, JavaType> substitutions = Maps.newLinkedHashMap();

    @CheckForNull
    public JavaType substitutedType(JavaType javaType) {
        return this.substitutions.get(javaType);
    }

    public List<JavaType.TypeVariableJavaType> typeVariables() {
        return Lists.newArrayList(this.substitutions.keySet());
    }

    public List<Map.Entry<JavaType.TypeVariableJavaType, JavaType>> substitutionEntries() {
        return Lists.newArrayList(this.substitutions.entrySet());
    }

    public List<JavaType> substitutedTypes() {
        return Lists.newArrayList(this.substitutions.values());
    }

    public TypeSubstitution add(JavaType.TypeVariableJavaType typeVariableType, JavaType javaType) {
        this.substitutions.put(typeVariableType, javaType);
        return this;
    }

    public int size() {
        return this.substitutions.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeSubstitution newSubstitution = (TypeSubstitution)obj;
        return this.substitutions.equals(newSubstitution.substitutions) && this.substitutionEntries().equals(newSubstitution.substitutionEntries());
    }

    public int hashCode() {
        return this.substitutionEntries().hashCode();
    }
}

