/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;

public class TypeSubstitutionSolver {
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Symbols symbols;

    public TypeSubstitutionSolver(ParametrizedTypeCache parametrizedTypeCache, Symbols symbols) {
        this.parametrizedTypeCache = parametrizedTypeCache;
        this.symbols = symbols;
    }

    @CheckForNull
    TypeSubstitution getTypeSubstitution(JavaSymbol.MethodJavaSymbol method, JavaType site, List<JavaType> typeParams, List<JavaType> argTypes) {
        List<JavaType> formals = ((JavaType.MethodJavaType)method.type).argTypes;
        TypeSubstitution substitution = new TypeSubstitution();
        if (method.isParametrized()) {
            if (!typeParams.isEmpty()) {
                substitution = this.getSubstitutionFromTypeParams(method.typeVariableTypes, typeParams);
            } else {
                if (formals.isEmpty()) {
                    return substitution;
                }
                formals = this.applySiteSubstitutionToFormalParameters(formals, site);
                substitution = this.inferTypeSubstitution(method, formals, argTypes);
            }
            if (substitution.size() == 0 || !this.isValidSubtitution(substitution, site)) {
                return null;
            }
        }
        return substitution;
    }

    JavaType getReturnType(@Nullable JavaType returnType, JavaType site, boolean parametrizedMethodCall, TypeSubstitution substitution) {
        if (returnType == null) {
            return returnType;
        }
        JavaType resultType = this.applySiteSubstitution(returnType, site);
        if (TypeSubstitutionSolver.isRawTypeOfParametrizedType(site) && !parametrizedMethodCall) {
            return resultType.erasure();
        }
        return this.applySubstitution(resultType, substitution);
    }

    private static boolean isRawTypeOfParametrizedType(JavaType site) {
        return !TypeSubstitutionSolver.isParametrizedType(site) && !site.symbol.typeVariableTypes.isEmpty();
    }

    List<JavaType> applySiteSubstitutionToFormalParameters(List<JavaType> formals, JavaType site) {
        if (TypeSubstitutionSolver.isParametrizedType(site)) {
            return this.applySubstitutionToFormalParameters(formals, ((JavaType.ParametrizedTypeJavaType)site).typeSubstitution);
        }
        return formals;
    }

    JavaType applySiteSubstitution(JavaType type, JavaType site) {
        if (TypeSubstitutionSolver.isParametrizedType(site)) {
            return this.applySubstitution(type, ((JavaType.ParametrizedTypeJavaType)site).typeSubstitution);
        }
        return type;
    }

    JavaType applySiteSubstitution(@Nullable JavaType resolvedType, JavaType callSite, JavaType resolvedTypeDefinition) {
        if (resolvedType == null) {
            return null;
        }
        return this.applySiteSubstitution(this.applySiteSubstitution(resolvedType, resolvedTypeDefinition), callSite);
    }

    List<JavaType> applySubstitutionToFormalParameters(List<JavaType> types, TypeSubstitution substitution) {
        if (substitution.size() == 0 || types.isEmpty()) {
            return types;
        }
        ArrayList<JavaType> results = new ArrayList<JavaType>(types.size());
        for (JavaType type : types) {
            results.add(this.applySubstitution(type, substitution));
        }
        return results;
    }

    private JavaType applySubstitution(JavaType type, TypeSubstitution substitution) {
        JavaType substitutedType = substitution.substitutedType(type);
        if (substitutedType != null) {
            return substitutedType;
        }
        if (TypeSubstitutionSolver.isParametrizedType(type)) {
            return this.substituteInParametrizedType((JavaType.ParametrizedTypeJavaType)type, substitution);
        }
        if (type.isTagged(16)) {
            return this.substituteInWildCardType((JavaType.WildCardType)type, substitution);
        }
        if (type.isArray()) {
            return this.substituteInArrayType((JavaType.ArrayJavaType)type, substitution);
        }
        return type;
    }

    private static boolean isParametrizedType(JavaType type) {
        return type instanceof JavaType.ParametrizedTypeJavaType;
    }

    private JavaType substituteInParametrizedType(JavaType.ParametrizedTypeJavaType type, TypeSubstitution substitution) {
        TypeSubstitution newSubstitution = new TypeSubstitution();
        for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> entry : type.typeSubstitution.substitutionEntries()) {
            newSubstitution.add(entry.getKey(), this.applySubstitution(entry.getValue(), substitution));
        }
        return this.parametrizedTypeCache.getParametrizedTypeType(type.rawType.getSymbol(), newSubstitution);
    }

    private JavaType substituteInWildCardType(JavaType.WildCardType wildcard, TypeSubstitution substitution) {
        JavaType substitutedType = substitution.substitutedType(wildcard.bound);
        if (substitutedType != null) {
            return this.parametrizedTypeCache.getWildcardType(substitutedType, wildcard.boundType);
        }
        return wildcard;
    }

    private JavaType substituteInArrayType(JavaType.ArrayJavaType arrayType, TypeSubstitution substitution) {
        JavaType rootElementType = arrayType.elementType;
        int nbDimensions = 1;
        while (rootElementType.isArray()) {
            rootElementType = ((JavaType.ArrayJavaType)rootElementType).elementType;
            ++nbDimensions;
        }
        JavaType substitutedType = substitution.substitutedType(rootElementType);
        if (substitutedType != null) {
            for (int i = 0; i < nbDimensions; ++i) {
                substitutedType = new JavaType.ArrayJavaType(substitutedType, this.symbols.arrayClass);
            }
            return substitutedType;
        }
        return arrayType;
    }

    TypeSubstitution getSubstitutionFromTypeParams(List<JavaType.TypeVariableJavaType> typeVariableTypes, List<JavaType> typeParams) {
        TypeSubstitution substitution = new TypeSubstitution();
        if (typeVariableTypes.size() == typeParams.size()) {
            for (int i = 0; i < typeVariableTypes.size(); ++i) {
                JavaType.TypeVariableJavaType typeVariableType = typeVariableTypes.get(i);
                JavaType typeParam = typeParams.get(i);
                substitution.add(typeVariableType, typeParam);
            }
        }
        return substitution;
    }

    private TypeSubstitution inferTypeSubstitution(JavaSymbol.MethodJavaSymbol method, List<JavaType> formals, List<JavaType> argTypes) {
        TypeSubstitution substitution = new TypeSubstitution();
        for (int i = 0; i < Math.min(formals.size(), argTypes.size()); ++i) {
            JavaType formalType = formals.get(i);
            JavaType argType = argTypes.get(i);
            boolean isLastParam = i == formals.size() - 1;
            if ((substitution = this.inferTypeSubstitution(method, substitution, isLastParam, formalType, argType)).typeVariables().containsAll(method.typeVariableTypes)) break;
        }
        return substitution;
    }

    /*
     * WARNING - void declaration
     */
    private TypeSubstitution inferTypeSubstitution(JavaSymbol.MethodJavaSymbol method, TypeSubstitution currentSubstitution, boolean isLastParam, JavaType formalType, JavaType argType) {
        if (formalType.isTagged(15)) {
            this.completeSubstitution(currentSubstitution, formalType, argType);
        } else if (formalType.isArray()) {
            JavaType formalElementType = ((JavaType.ArrayJavaType)formalType).elementType;
            if (argType.isArray()) {
                this.completeSubstitution(currentSubstitution, formalElementType, ((JavaType.ArrayJavaType)argType).elementType);
            } else if (method.isVarArgs() && isLastParam) {
                this.completeSubstitution(currentSubstitution, formalElementType, argType);
            }
        } else if (TypeSubstitutionSolver.isParametrizedType(formalType)) {
            List<JavaType> formalTypeSubstitutedTypes = ((JavaType.ParametrizedTypeJavaType)formalType).typeSubstitution.substitutedTypes();
            if (TypeSubstitutionSolver.isParametrizedType(argType)) {
                List<JavaType> argTypeSubstitutedTypes = ((JavaType.ParametrizedTypeJavaType)argType).typeSubstitution.substitutedTypes();
                TypeSubstitution typeSubstitution = this.inferTypeSubstitution(method, formalTypeSubstitutedTypes, argTypeSubstitutedTypes);
                return TypeSubstitutionSolver.mergeTypeSubstitutions(currentSubstitution, typeSubstitution);
            }
            if (TypeSubstitutionSolver.isRawTypeOfType(argType, formalType) || this.isNullType(argType)) {
                void var8_13;
                ArrayList<JavaType> fakeTypes = new ArrayList<JavaType>(formalTypeSubstitutedTypes.size());
                boolean bl = false;
                while (var8_13 < formalTypeSubstitutedTypes.size()) {
                    fakeTypes.add(this.symbols.objectType);
                    ++var8_13;
                }
                TypeSubstitution typeSubstitution = this.inferTypeSubstitution(method, formalTypeSubstitutedTypes, fakeTypes);
                return TypeSubstitutionSolver.mergeTypeSubstitutions(currentSubstitution, typeSubstitution);
            }
            if (argType.isSubtypeOf(formalType.erasure()) && argType.isClass()) {
                for (JavaType javaType : ((JavaType.ClassJavaType)argType).symbol.superTypes()) {
                    if (!TypeSubstitutionSolver.sameErasure(formalType, javaType)) continue;
                    return this.inferTypeSubstitution(method, currentSubstitution, isLastParam, formalType, javaType);
                }
            }
        } else if (formalType.isTagged(16)) {
            this.completeSubstitution(currentSubstitution, ((JavaType.WildCardType)formalType).bound, argType);
        }
        return currentSubstitution;
    }

    private static boolean sameErasure(JavaType formalType, JavaType superType) {
        return formalType.erasure() == superType.erasure();
    }

    private boolean isNullType(JavaType argType) {
        return argType == this.symbols.nullType;
    }

    private static boolean isRawTypeOfType(JavaType argType, JavaType formalType) {
        return argType == formalType.erasure();
    }

    private static TypeSubstitution mergeTypeSubstitutions(TypeSubstitution currentSubstitution, TypeSubstitution newSubstitution) {
        TypeSubstitution result = new TypeSubstitution();
        for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> substitution : currentSubstitution.substitutionEntries()) {
            result.add(substitution.getKey(), substitution.getValue());
        }
        for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> substitution : newSubstitution.substitutionEntries()) {
            if (result.typeVariables().contains(substitution.getKey())) continue;
            result.add(substitution.getKey(), substitution.getValue());
        }
        return result;
    }

    private void completeSubstitution(TypeSubstitution currentSubstitution, JavaType formalType, JavaType argType) {
        if (formalType.isTagged(15) && currentSubstitution.substitutedType(formalType) == null) {
            JavaType expectedType = argType;
            if (expectedType.isPrimitive()) {
                expectedType = expectedType.primitiveWrapperType;
            } else if (this.isNullType(expectedType)) {
                expectedType = this.symbols.objectType;
            }
            JavaType.TypeVariableJavaType typeVar = (JavaType.TypeVariableJavaType)formalType;
            currentSubstitution.add(typeVar, expectedType);
        }
    }

    private boolean isValidSubtitution(TypeSubstitution substitutions, JavaType site) {
        for (Map.Entry<JavaType.TypeVariableJavaType, JavaType> substitution : substitutions.substitutionEntries()) {
            if (this.isValidSubstitution(substitutions, substitution.getKey(), substitution.getValue(), site)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidSubstitution(TypeSubstitution candidate, JavaType.TypeVariableJavaType typeVar, JavaType typeParam, JavaType site) {
        for (JavaType bound : typeVar.bounds) {
            JavaType currentBound = this.applySubstitution(bound, candidate);
            while (currentBound.isTagged(15)) {
                JavaType newBound = candidate.substitutedType(currentBound);
                if (newBound == null && TypeSubstitutionSolver.isParametrizedType(site)) {
                    newBound = ((JavaType.ParametrizedTypeJavaType)site).typeSubstitution.substitutedType(currentBound);
                }
                if (newBound == null) {
                    return false;
                }
                currentBound = newBound;
            }
            if (typeParam.isSubtypeOf(currentBound)) continue;
            return false;
        }
        return true;
    }
}

