/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2583", name="Conditions should not unconditionally evaluate to \"TRUE\" or to \"FALSE\"", priority=Priority.BLOCKER, tags={"bug", "cwe", "misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class ConditionAlwaysTrueOrFalseCheck
extends SECheck {
    private final Set<Tree> evaluatedToFalse = Sets.newHashSet();
    private final Set<Tree> evaluatedToTrue = Sets.newHashSet();

    @Override
    public void init() {
        this.evaluatedToFalse.clear();
        this.evaluatedToTrue.clear();
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        for (Tree condition : Sets.difference(this.evaluatedToFalse, this.evaluatedToTrue)) {
            context.reportIssue(condition, this, "Change this condition so that it does not always evaluate to \"false\"");
        }
        for (Tree condition : Sets.difference(this.evaluatedToTrue, this.evaluatedToFalse)) {
            context.reportIssue(condition, this, "Change this condition so that it does not always evaluate to \"true\"");
        }
    }

    public void evaluatedToFalse(Tree condition) {
        this.evaluatedToFalse.add(condition);
    }

    public void evaluatedToTrue(Tree condition) {
        this.evaluatedToTrue.add(condition);
    }
}

