/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.constraint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.se.Pair;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValueFactory;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.NullCheckSymbolicValue;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ConstraintManager {
    private int counter = ProgramState.EMPTY_STATE.constraintsSize();
    private SymbolicValueFactory symbolicValueFactory;

    public void setValueFactory(SymbolicValueFactory valueFactory) {
        Preconditions.checkState((this.symbolicValueFactory == null ? 1 : 0) != 0, (Object)"The symbolic value factory has already been defined by another checker!");
        this.symbolicValueFactory = valueFactory;
    }

    public SymbolicValue createSymbolicValue(Tree syntaxNode) {
        SymbolicValue result;
        switch (syntaxNode.kind()) {
            case EQUAL_TO: {
                result = new RelationalSymbolicValue(this.counter, RelationalSymbolicValue.Kind.EQUAL);
                break;
            }
            case NOT_EQUAL_TO: {
                result = new RelationalSymbolicValue(this.counter, RelationalSymbolicValue.Kind.NOT_EQUAL);
                break;
            }
            case LESS_THAN: {
                result = new RelationalSymbolicValue(this.counter, RelationalSymbolicValue.Kind.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                result = new RelationalSymbolicValue(this.counter, RelationalSymbolicValue.Kind.LESS_THAN_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                result = new RelationalSymbolicValue(this.counter, RelationalSymbolicValue.Kind.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                result = new RelationalSymbolicValue(this.counter, RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL);
                break;
            }
            case LOGICAL_COMPLEMENT: {
                result = new SymbolicValue.NotSymbolicValue(this.counter);
                break;
            }
            case AND: 
            case AND_ASSIGNMENT: {
                result = new SymbolicValue.AndSymbolicValue(this.counter);
                break;
            }
            case OR: 
            case OR_ASSIGNMENT: {
                result = new SymbolicValue.OrSymbolicValue(this.counter);
                break;
            }
            case XOR: 
            case XOR_ASSIGNMENT: {
                result = new SymbolicValue.XorSymbolicValue(this.counter);
                break;
            }
            case INSTANCE_OF: {
                result = new SymbolicValue.InstanceOfSymbolicValue(this.counter);
                break;
            }
            case MEMBER_SELECT: {
                result = this.createIdentifierSymbolicValue(((MemberSelectExpressionTree)syntaxNode).identifier());
                break;
            }
            case IDENTIFIER: {
                result = this.createIdentifierSymbolicValue((IdentifierTree)syntaxNode);
                break;
            }
            default: {
                result = this.createDefaultSymbolicValue(syntaxNode);
            }
        }
        ++this.counter;
        return result;
    }

    public SymbolicValue createMethodSymbolicValue(MethodInvocationTree syntaxNode, List<SymbolicValue> values) {
        SymbolicValue result;
        if (ConstraintManager.isEqualsMethod(syntaxNode)) {
            result = new RelationalSymbolicValue(this.counter, RelationalSymbolicValue.Kind.METHOD_EQUALS);
            SymbolicValue leftOp = values.get(0);
            SymbolicValue rightOp = values.get(1);
            result.computedFrom((List<SymbolicValue>)ImmutableList.of((Object)rightOp, (Object)leftOp));
        } else if (ConstraintManager.isObjectsMethod(syntaxNode.symbol(), "isNull")) {
            result = new NullCheckSymbolicValue(this.counter, true);
            SymbolicValue operand = values.get(1);
            result.computedFrom((List<SymbolicValue>)ImmutableList.of((Object)operand));
        } else if (ConstraintManager.isObjectsMethod(syntaxNode.symbol(), "nonNull")) {
            result = new NullCheckSymbolicValue(this.counter, false);
            SymbolicValue operand = values.get(1);
            result.computedFrom((List<SymbolicValue>)ImmutableList.of((Object)operand));
        } else {
            result = this.createDefaultSymbolicValue(syntaxNode);
        }
        ++this.counter;
        return result;
    }

    private static boolean isObjectsMethod(Symbol symbol, String methodName) {
        return symbol.owner().type().is("java.util.Objects") && methodName.equals(symbol.name());
    }

    private static boolean isEqualsMethod(MethodInvocationTree syntaxNode) {
        MemberSelectExpressionTree expression;
        ExpressionTree methodSelect;
        if (syntaxNode.arguments().size() == 1 && (methodSelect = syntaxNode.methodSelect()).is(Tree.Kind.MEMBER_SELECT) && "equals".equals((expression = (MemberSelectExpressionTree)methodSelect).identifier().name()) && syntaxNode.symbol().isMethodSymbol()) {
            Symbol.MethodSymbol symbol = (Symbol.MethodSymbol)syntaxNode.symbol();
            return symbol.parameterTypes().get(0).is("java.lang.Object");
        }
        return false;
    }

    private SymbolicValue createIdentifierSymbolicValue(IdentifierTree identifier) {
        Type type = identifier.symbol().type();
        if (type != null && type.is("java.lang.Boolean")) {
            if ("TRUE".equals(identifier.name())) {
                return SymbolicValue.TRUE_LITERAL;
            }
            if ("FALSE".equals(identifier.name())) {
                return SymbolicValue.FALSE_LITERAL;
            }
        }
        return this.createDefaultSymbolicValue(identifier);
    }

    private SymbolicValue createDefaultSymbolicValue(Tree syntaxNode) {
        SymbolicValue result = this.symbolicValueFactory == null ? new SymbolicValue(this.counter) : this.symbolicValueFactory.createSymbolicValue(this.counter, syntaxNode);
        this.symbolicValueFactory = null;
        return result;
    }

    public SymbolicValue evalLiteral(LiteralTree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.NULL_LITERAL)) {
            return SymbolicValue.NULL_LITERAL;
        }
        if (syntaxNode.is(Tree.Kind.BOOLEAN_LITERAL)) {
            boolean value = Boolean.parseBoolean(syntaxNode.value());
            if (value) {
                return SymbolicValue.TRUE_LITERAL;
            }
            return SymbolicValue.FALSE_LITERAL;
        }
        return this.createSymbolicValue(syntaxNode);
    }

    public boolean isNull(ProgramState ps, SymbolicValue val) {
        Constraint constraint = ps.getConstraint(val);
        return constraint instanceof ObjectConstraint && ((ObjectConstraint)constraint).isNull();
    }

    public Pair<List<ProgramState>, List<ProgramState>> assumeDual(ProgramState programState) {
        ProgramState.Pop unstack = programState.unstackValue(1);
        SymbolicValue sv = unstack.values.get(0);
        List<ProgramState> falseConstraint = sv.setConstraint(unstack.state, BooleanConstraint.FALSE);
        List<ProgramState> trueConstraint = sv.setConstraint(unstack.state, BooleanConstraint.TRUE);
        return new Pair<List<ProgramState>, List<ProgramState>>(falseConstraint, trueConstraint);
    }
}

