/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.EqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanRelation;
import org.sonar.java.se.symbolicvalues.LessThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.MethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.NotMethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public abstract class BinaryRelation {
    protected final RelationalSymbolicValue.Kind kind;
    protected final SymbolicValue leftOp;
    protected final SymbolicValue rightOp;
    protected BinaryRelation symmetric;
    protected BinaryRelation inverse;
    private final int hashcode;

    public static BinaryRelation binaryRelation(RelationalSymbolicValue.Kind kind, SymbolicValue leftOp, SymbolicValue rightOp) {
        BinaryRelation relation;
        switch (kind) {
            case EQUAL: {
                relation = new EqualRelation(leftOp, rightOp);
                relation.inverse = new NotEqualRelation(leftOp, rightOp);
                relation.inverse.symmetric = new NotEqualRelation(rightOp, leftOp);
                relation.inverse.inverse = relation;
                relation.symmetric = new EqualRelation(rightOp, leftOp);
                relation.symmetric.symmetric = relation;
                relation.symmetric.inverse = relation.inverse.symmetric;
                break;
            }
            case NOT_EQUAL: {
                relation = BinaryRelation.binaryRelation((RelationalSymbolicValue.Kind)RelationalSymbolicValue.Kind.EQUAL, (SymbolicValue)leftOp, (SymbolicValue)rightOp).inverse;
                break;
            }
            case LESS_THAN: {
                relation = new LessThanRelation(leftOp, rightOp);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                relation = new LessThanOrEqualRelation(leftOp, rightOp);
                break;
            }
            case GREATER_THAN: {
                relation = new GreaterThanRelation(leftOp, rightOp);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                relation = new GreaterThanOrEqualRelation(leftOp, rightOp);
                break;
            }
            case METHOD_EQUALS: {
                relation = new MethodEqualsRelation(leftOp, rightOp);
                break;
            }
            case NOT_METHOD_EQUALS: {
                relation = new NotMethodEqualsRelation(leftOp, rightOp);
                break;
            }
            default: {
                throw new IllegalStateException("Creation of relation of kind " + (Object)((Object)kind) + " is missing!");
            }
        }
        return relation;
    }

    protected BinaryRelation(RelationalSymbolicValue.Kind kind, SymbolicValue v1, SymbolicValue v2) {
        this.kind = kind;
        this.leftOp = v1;
        this.rightOp = v2;
        this.hashcode = Objects.hash(new Object[]{kind, this.leftOp, this.rightOp});
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BinaryRelation) {
            return this.equalsRelation((BinaryRelation)obj);
        }
        return false;
    }

    private boolean equalsRelation(BinaryRelation rel) {
        if (this.kind.equals((Object)rel.kind)) {
            return this.leftOp.id() == rel.leftOp.id() && this.rightOp.id() == rel.rightOp.id();
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.leftOp);
        buffer.append(this.kind.operand);
        buffer.append(this.rightOp);
        return buffer.toString();
    }

    protected RelationState resolveState(Collection<BinaryRelation> knownRelations) {
        return this.resolveState(knownRelations, new HashSet<BinaryRelation>());
    }

    @CheckForNull
    protected RelationState resolveState(Collection<BinaryRelation> knownRelations, Set<BinaryRelation> usedRelations) {
        if (this.leftOp.equals(this.rightOp)) {
            return this.relationStateForSameOperand();
        }
        if (knownRelations.isEmpty()) {
            return RelationState.UNDETERMINED;
        }
        if (usedRelations.size() > 200) {
            throw new TransitiveRelationExceededException();
        }
        for (BinaryRelation relation : knownRelations) {
            RelationState result = relation.implies(this);
            if (result.isDetermined()) {
                return result;
            }
            usedRelations.add(relation);
            usedRelations.add(relation.symmetric());
        }
        Collection<BinaryRelation> transitiveReduction = this.transitiveReduction(knownRelations, usedRelations);
        if (transitiveReduction.isEmpty()) {
            transitiveReduction = this.symmetric().transitiveReduction(knownRelations, usedRelations);
        }
        return this.resolveState(transitiveReduction, usedRelations);
    }

    private RelationState relationStateForSameOperand() {
        switch (this.kind) {
            case EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case METHOD_EQUALS: {
                return RelationState.FULFILLED;
            }
            case NOT_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case NOT_METHOD_EQUALS: {
                return RelationState.UNFULFILLED;
            }
        }
        throw new IllegalStateException("Binary relation kind unsupported" + (Object)((Object)this.kind));
    }

    private Collection<BinaryRelation> transitiveReduction(Collection<BinaryRelation> knownRelations, Set<BinaryRelation> usedRelations) {
        boolean changed = false;
        ArrayList<BinaryRelation> result = new ArrayList<BinaryRelation>();
        for (BinaryRelation relation : knownRelations) {
            boolean used = false;
            if (this.leftOp.equals(relation.leftOp)) {
                used = result.addAll(relation.combinedRelations(knownRelations, usedRelations));
            } else if (this.leftOp.equals(relation.rightOp)) {
                used = result.addAll(relation.symmetric().combinedRelations(knownRelations, usedRelations));
            }
            if (used) {
                changed = true;
                continue;
            }
            result.add(relation);
        }
        return changed ? result : Collections.emptyList();
    }

    private Collection<BinaryRelation> combinedRelations(Collection<BinaryRelation> relations, Set<BinaryRelation> usedRelations) {
        ArrayList<BinaryRelation> result = new ArrayList<BinaryRelation>();
        for (BinaryRelation relation : relations) {
            BinaryRelation combined;
            if (this.equals(relation) || (combined = this.combineUnordered(relation)) == null || usedRelations.contains(combined)) continue;
            result.add(combined);
        }
        return result;
    }

    @CheckForNull
    @VisibleForTesting
    BinaryRelation combineUnordered(BinaryRelation relation) {
        BinaryRelation combined = null;
        if (this.rightOp.equals(relation.leftOp)) {
            combined = relation.combineOrdered(this);
        } else if (this.rightOp.equals(relation.rightOp)) {
            combined = relation.symmetric().combineOrdered(this);
        }
        return combined;
    }

    @CheckForNull
    private BinaryRelation combineOrdered(BinaryRelation relation) {
        Preconditions.checkArgument((boolean)this.leftOp.equals(relation.rightOp), (Object)"Transitive condition not matched!");
        if (this.rightOp.equals(relation.leftOp)) {
            return this.conjunction(relation.symmetric());
        }
        return this.combinedAfter(relation);
    }

    @CheckForNull
    protected BinaryRelation conjunction(BinaryRelation relation) {
        Preconditions.checkArgument((this.leftOp.equals(relation.leftOp) && this.rightOp.equals(relation.rightOp) ? 1 : 0) != 0, (Object)"Conjunction condition not matched!");
        return null;
    }

    public BinaryRelation inverse() {
        if (this.inverse == null) {
            this.inverse = BinaryRelation.binaryRelation(this.kind.inverse(), this.leftOp, this.rightOp);
        }
        return this.inverse;
    }

    protected BinaryRelation symmetric() {
        if (this.symmetric == null) {
            this.symmetric = BinaryRelation.binaryRelation(this.kind.symmetric(), this.rightOp, this.leftOp);
        }
        return this.symmetric;
    }

    protected RelationState implies(BinaryRelation relation) {
        if (this.leftOp.equals(relation.leftOp) && this.rightOp.equals(relation.rightOp)) {
            return relation.isImpliedBy(this);
        }
        if (this.leftOp.equals(relation.rightOp) && this.rightOp.equals(relation.leftOp)) {
            return relation.symmetric().isImpliedBy(this);
        }
        return RelationState.UNDETERMINED;
    }

    protected abstract RelationState isImpliedBy(BinaryRelation var1);

    protected abstract RelationState impliesEqual();

    protected abstract RelationState impliesNotEqual();

    protected abstract RelationState impliesMethodEquals();

    protected abstract RelationState impliesNotMethodEquals();

    protected abstract RelationState impliesGreaterThan();

    protected abstract RelationState impliesGreaterThanOrEqual();

    protected abstract RelationState impliesLessThan();

    protected abstract RelationState impliesLessThanOrEqual();

    @CheckForNull
    protected abstract BinaryRelation combinedAfter(BinaryRelation var1);

    @CheckForNull
    protected abstract BinaryRelation combinedWithEqual(EqualRelation var1);

    @CheckForNull
    protected abstract BinaryRelation combinedWithNotEqual(NotEqualRelation var1);

    @CheckForNull
    protected abstract BinaryRelation combinedWithMethodEquals(MethodEqualsRelation var1);

    @CheckForNull
    protected abstract BinaryRelation combinedWithNotMethodEquals(NotMethodEqualsRelation var1);

    @CheckForNull
    protected abstract BinaryRelation combinedWithGreaterThan(GreaterThanRelation var1);

    @CheckForNull
    protected abstract BinaryRelation combinedWithGreaterThanOrEqual(GreaterThanOrEqualRelation var1);

    @CheckForNull
    protected abstract BinaryRelation combinedWithLessThan(LessThanRelation var1);

    @CheckForNull
    protected abstract BinaryRelation combinedWithLessThanOrEqual(LessThanOrEqualRelation var1);

    public static class TransitiveRelationExceededException
    extends RuntimeException {
        public TransitiveRelationExceededException() {
            super("Number of transitive relations exceeded!");
        }
    }
}

