/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.java.AbstractJavaClasspath;

public class JavaTestClasspath
extends AbstractJavaClasspath {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTestClasspath.class);

    public JavaTestClasspath(Project project, Settings settings, FileSystem fs) {
        super(project, settings, fs, InputFile.Type.TEST);
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("JavaTestClasspath initialization");
            this.initialized = true;
            this.validateLibraries = this.project.getModules().isEmpty();
            this.binaries = this.getFilesFromProperty("sonar.java.test.binaries");
            List<File> libraries = this.getFilesFromProperty("sonar.java.test.libraries");
            if (libraries.isEmpty()) {
                LOG.warn("Bytecode of dependencies was not provided for analysis of test files, you might end up with less precise results. Bytecode can be provided using sonar.java.test.libraries property");
            }
            this.elements = Lists.newArrayList((Iterable)this.binaries);
            this.elements.addAll(libraries);
            profiler.stop();
        }
    }
}

