/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.sonar.java.bytecode.loader.Loader;

class FileSystemLoader
implements Loader {
    private File baseDir;

    public FileSystemLoader(File baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir can't be null");
        }
        this.baseDir = baseDir;
    }

    @Override
    public URL findResource(String name) {
        if (this.baseDir == null) {
            throw new IllegalStateException("Loader closed");
        }
        File file = new File(this.baseDir, name);
        if (file.exists() && file.isFile()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] loadBytes(String name) {
        if (this.baseDir == null) {
            throw new IllegalStateException("Loader closed");
        }
        File file = new File(this.baseDir, name);
        if (!file.exists()) {
            return new byte[0];
        }
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    @Override
    public void close() {
        this.baseDir = null;
    }
}

