/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.statement.CaseGroupTreeImpl;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class SwitchStatementTreeImpl
extends JavaTree
implements SwitchStatementTree {
    private final ExpressionTree expression;
    private final List<CaseGroupTree> cases;
    private final InternalSyntaxToken switchKeyword;
    private final InternalSyntaxToken openParenToken;
    private final InternalSyntaxToken closeParenToken;
    private final InternalSyntaxToken openBraceToken;
    private final InternalSyntaxToken closeBraceToken;

    public SwitchStatementTreeImpl(InternalSyntaxToken switchKeyword, InternalSyntaxToken openParenToken, ExpressionTree expression, InternalSyntaxToken closeParenToken, InternalSyntaxToken openBraceToken, List<CaseGroupTreeImpl> groups, InternalSyntaxToken closeBraceToken) {
        super(Tree.Kind.SWITCH_STATEMENT);
        this.switchKeyword = switchKeyword;
        this.openParenToken = openParenToken;
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.closeParenToken = closeParenToken;
        this.openBraceToken = openBraceToken;
        this.cases = ImmutableList.builder().addAll((Iterable)Preconditions.checkNotNull(groups)).build();
        this.closeBraceToken = closeBraceToken;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.SWITCH_STATEMENT;
    }

    @Override
    public SyntaxToken switchKeyword() {
        return this.switchKeyword;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public SyntaxToken openBraceToken() {
        return this.openBraceToken;
    }

    @Override
    public List<CaseGroupTree> cases() {
        return this.cases;
    }

    @Override
    public SyntaxToken closeBraceToken() {
        return this.closeBraceToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSwitchStatement(this);
    }

    @Override
    public Iterable<Tree> children() {
        return Iterables.concat((Iterable)Lists.newArrayList((Object[])new Tree[]{this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken}), this.cases, Collections.singletonList(this.closeBraceToken));
    }
}

