/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.java.collections.PMap;
import org.sonar.java.collections.PSet;

public abstract class AVLTree<K, V>
implements PMap<K, V>,
PSet<K> {
    private static final AVLTree EMPTY = new AVLTree(){

        @Override
        protected AVLTree left() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected AVLTree right() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object key() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object value() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int height() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof AVLTree && ((AVLTree)obj).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "";
        }
    };
    private static final Comparator KEY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            int h2;
            int h1 = o1.hashCode();
            if (h1 == (h2 = o2.hashCode())) {
                return o1.equals(o2) ? 0 : 1;
            }
            return h1 - h2;
        }
    };

    public static <K, V> AVLTree<K, V> create() {
        return EMPTY;
    }

    public AVLTree<K, V> add(K e) {
        return AVLTree.put(e, e, this);
    }

    @Override
    public boolean contains(K k) {
        return this.get(k) != null;
    }

    @Override
    public AVLTree<K, V> put(K key, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        return AVLTree.put(key, value, this);
    }

    @Override
    public AVLTree<K, V> remove(K key) {
        Preconditions.checkNotNull(key);
        return AVLTree.remove(key, this);
    }

    @Override
    @Nullable
    public V get(K key) {
        Preconditions.checkNotNull(key);
        AVLTree t = this;
        while (!t.isEmpty()) {
            int c = KEY_COMPARATOR.compare(key, t.key());
            if (c == 0) {
                return (V)t.value();
            }
            if (c < 0) {
                t = t.left();
                continue;
            }
            t = t.right();
        }
        return null;
    }

    @Override
    public void forEach(PSet.Consumer<K> action) {
        this.forEach(this, action);
    }

    private void forEach(AVLTree t, PSet.Consumer<K> action) {
        if (t.isEmpty()) {
            return;
        }
        this.forEach(t.left(), action);
        action.accept(t.key());
        this.forEach(t.right(), action);
    }

    @Override
    public void forEach(PMap.Consumer<K, V> consumer) {
        this.forEach(this, consumer);
    }

    private void forEach(AVLTree t, PMap.Consumer<K, V> action) {
        if (t.isEmpty()) {
            return;
        }
        this.forEach(t.left(), action);
        action.accept(t.key(), t.value());
        this.forEach(t.right(), action);
    }

    @Override
    public Iterator<Map.Entry<K, V>> entriesIterator() {
        return new NodeIterator(this);
    }

    protected abstract AVLTree left();

    protected abstract AVLTree right();

    protected abstract Object key();

    protected abstract Object value();

    protected abstract int height();

    private static AVLTree put(Object key, Object value, AVLTree t) {
        if (t.isEmpty()) {
            return AVLTree.createNode(t, key, value, t);
        }
        int result = KEY_COMPARATOR.compare(key, t.key());
        if (result == 0) {
            if (value.equals(t.value())) {
                return t;
            }
            return AVLTree.createNode(t.left(), key, value, t.right());
        }
        if (result < 0) {
            AVLTree left = AVLTree.put(key, value, t.left());
            if (left == t.left()) {
                return t;
            }
            return AVLTree.balance(left, t.key(), t.value(), t.right());
        }
        AVLTree right = AVLTree.put(key, value, t.right());
        if (right == t.right()) {
            return t;
        }
        return AVLTree.balance(t.left(), t.key(), t.value(), right);
    }

    private static AVLTree remove(Object key, AVLTree t) {
        if (t.isEmpty()) {
            return t;
        }
        int result = KEY_COMPARATOR.compare(key, t.key());
        if (result == 0) {
            return AVLTree.combineTrees(t.left(), t.right());
        }
        if (result < 0) {
            AVLTree left = AVLTree.remove(key, t.left());
            if (left == t.left()) {
                return t;
            }
            return AVLTree.balance(left, t.key(), t.value(), t.right());
        }
        AVLTree right = AVLTree.remove(key, t.right());
        if (right == t.right()) {
            return t;
        }
        return AVLTree.balance(t.left(), t.key(), t.value(), right);
    }

    private static AVLTree combineTrees(AVLTree l, AVLTree r) {
        if (l.isEmpty()) {
            return r;
        }
        if (r.isEmpty()) {
            return l;
        }
        NodeRef oldNode = new NodeRef();
        AVLTree newRight = AVLTree.removeMinBinding(r, oldNode);
        return AVLTree.balance(l, oldNode.node.key(), oldNode.node.value(), newRight);
    }

    private static AVLTree removeMinBinding(AVLTree t, NodeRef noderemoved) {
        assert (!t.isEmpty());
        if (t.left().isEmpty()) {
            noderemoved.node = t;
            return t.right();
        }
        return AVLTree.balance(AVLTree.removeMinBinding(t.left(), noderemoved), t.key(), t.value(), t.right());
    }

    private static AVLTree balance(AVLTree l, Object key, Object value, AVLTree r) {
        if (l.height() > r.height() + 2) {
            assert (!l.isEmpty());
            AVLTree ll = l.left();
            AVLTree lr = l.right();
            if (ll.height() >= lr.height()) {
                return AVLTree.createNode(ll, l, AVLTree.createNode(lr, key, value, r));
            }
            assert (!lr.isEmpty());
            AVLTree lrl = lr.left();
            AVLTree lrr = lr.right();
            return AVLTree.createNode(AVLTree.createNode(ll, l, lrl), lr, AVLTree.createNode(lrr, key, value, r));
        }
        if (r.height() > l.height() + 2) {
            assert (!r.isEmpty());
            AVLTree rl = r.left();
            AVLTree rr = r.right();
            if (rr.height() >= rl.height()) {
                return AVLTree.createNode(AVLTree.createNode(l, key, value, rl), r, rr);
            }
            assert (!rl.isEmpty());
            AVLTree rll = rl.left();
            AVLTree rlr = rl.right();
            return AVLTree.createNode(AVLTree.createNode(l, key, value, rll), rl, AVLTree.createNode(rlr, r, rr));
        }
        return AVLTree.createNode(l, key, value, r);
    }

    private static AVLTree createNode(AVLTree newLeft, AVLTree oldTree, AVLTree newRight) {
        return AVLTree.createNode(newLeft, oldTree.key(), oldTree.value(), newRight);
    }

    private static AVLTree createNode(AVLTree l, Object key, Object value, AVLTree r) {
        return new Node(l, r, key, value, AVLTree.incrementHeight(l, r));
    }

    private static int incrementHeight(AVLTree l, AVLTree r) {
        return (l.height() > r.height() ? l.height() : r.height()) + 1;
    }

    private static class Node
    extends AVLTree {
        private final AVLTree left;
        private final AVLTree right;
        private final int height;
        private final Object key;
        private final Object value;
        private int hashCode;

        public Node(AVLTree left, AVLTree right, Object key, Object value, int height) {
            this.left = left;
            this.right = right;
            this.key = key;
            this.value = value;
            this.height = height;
        }

        @Override
        protected AVLTree left() {
            return this.left;
        }

        @Override
        protected AVLTree right() {
            return this.right;
        }

        @Override
        protected Object key() {
            return this.key;
        }

        @Override
        protected Object value() {
            return this.value;
        }

        @Override
        protected int height() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                Hasher hasher = new Hasher();
                this.forEach(hasher);
                this.hashCode = hasher.result;
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Node) {
                Node other = (Node)obj;
                int c = 0;
                Iterator iter = this.entriesIterator();
                while (iter.hasNext()) {
                    Map.Entry next = iter.next();
                    Object otherValue = other.get(next.getKey());
                    if (otherValue == null || !Objects.equals(next.getValue(), otherValue)) {
                        return false;
                    }
                    ++c;
                }
                return c == Iterators.size(other.entriesIterator());
            }
            return false;
        }

        public String toString() {
            return this.left.toString() + " " + this.key + "->" + this.value + this.right.toString();
        }

        private static class Hasher
        implements PMap.Consumer<Object, Object> {
            int result = 0;

            private Hasher() {
            }

            @Override
            public void accept(Object key, Object value) {
                this.result += 31 * key.hashCode() ^ value.hashCode();
            }
        }
    }

    private static class NodeRef {
        AVLTree node;

        private NodeRef() {
        }
    }

    public static interface Visitor<K, V> {
        public void visit(K var1, V var2);
    }

    private class NodeIterator
    implements Iterator<Map.Entry<K, V>> {
        private Deque<AVLTree> stack = new ArrayDeque<AVLTree>();

        public NodeIterator(AVLTree<K, V> node) {
            this.descendLeft(node);
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        private void descendLeft(AVLTree node) {
            if (node != EMPTY) {
                this.stack.addLast(node);
                this.descendLeft(node.left());
            }
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AVLTree node = this.stack.removeLast();
            if (node.right() != EMPTY) {
                this.descendLeft(node.right());
            }
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(node.key(), node.value());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

