/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.TypeSubstitution;

public class ParametrizedTypeCache {
    private Map<JavaSymbol, Map<TypeSubstitution, JavaType.ParametrizedTypeJavaType>> typeCache = Maps.newHashMap();
    private Map<JavaType, Map<JavaType.WildCardType.BoundType, JavaType.WildCardType>> wildcardCache = Maps.newHashMap();

    public JavaType getParametrizedTypeType(JavaSymbol.TypeJavaSymbol symbol, TypeSubstitution typeSubstitution) {
        if (symbol.getType().isUnknown()) {
            return symbol.getType();
        }
        if (this.typeCache.get(symbol) == null) {
            HashMap map = Maps.newHashMap();
            this.typeCache.put(symbol, map);
        }
        if (this.typeCache.get(symbol).get(typeSubstitution) == null) {
            this.typeCache.get(symbol).put(typeSubstitution, new JavaType.ParametrizedTypeJavaType(symbol, typeSubstitution));
        }
        return this.typeCache.get(symbol).get(typeSubstitution);
    }

    public JavaType getWildcardType(JavaType bound, JavaType.WildCardType.BoundType boundType) {
        JavaType.WildCardType wildcardType;
        Map<JavaType.WildCardType.BoundType, JavaType.WildCardType> map = this.wildcardCache.get(bound);
        if (map == null) {
            map = new EnumMap<JavaType.WildCardType.BoundType, JavaType.WildCardType>(JavaType.WildCardType.BoundType.class);
            this.wildcardCache.put(bound, map);
        }
        if ((wildcardType = map.get((Object)boundType)) == null) {
            wildcardType = new JavaType.WildCardType(bound, boundType);
            map.put(boundType, wildcardType);
        }
        return wildcardType;
    }
}

