/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.xml;

import java.io.File;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private static final Logger LOG = LoggerFactory.getLogger(XmlParser.class);
    public static final String START_LINE_ATTRIBUTE = "start_line";
    public static final String START_COLUMN_ATTRIBUTE = "start_column";
    public static final String END_LINE_ATTRIBUTE = "end_line";
    public static final String END_COLUMN_ATTRIBUTE = "end_column";

    private XmlParser() {
    }

    public static Document parseXML(File file) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.newSAXParser().parse(file, (DefaultHandler)new LocationHandler(document));
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("Unable to parse xml file: " + file.getPath(), (Throwable)e);
            return null;
        }
    }

    private static class LocationHandler
    extends DefaultHandler {
        private final Document document;
        private final Deque<Element> elementStack = new LinkedList<Element>();
        private Locator locator;
        private StringBuilder textBuffer = new StringBuilder();

        public LocationHandler(Document document) {
            this.document = document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.addTextNode();
            Element startingElement = this.document.createElement(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                startingElement.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            LocationHandler.savePosition(startingElement, XmlParser.START_LINE_ATTRIBUTE, this.locator.getLineNumber());
            LocationHandler.savePosition(startingElement, XmlParser.START_COLUMN_ATTRIBUTE, this.locator.getColumnNumber());
            this.elementStack.push(startingElement);
        }

        private static void savePosition(Element element, String attribute, int value) {
            element.setAttribute(attribute, String.valueOf(value));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.addTextNode();
            Element endingElement = this.elementStack.pop();
            LocationHandler.savePosition(endingElement, XmlParser.END_LINE_ATTRIBUTE, this.locator.getLineNumber());
            LocationHandler.savePosition(endingElement, XmlParser.END_COLUMN_ATTRIBUTE, this.locator.getColumnNumber());
            if (this.elementStack.isEmpty()) {
                this.document.appendChild(endingElement);
            } else {
                Element parentElement = this.elementStack.peek();
                parentElement.appendChild(endingElement);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length);
            if (!StringUtils.isBlank((String)s)) {
                this.textBuffer.append(s);
            }
        }

        private void addTextNode() {
            if (this.textBuffer.length() > 0) {
                Element element = this.elementStack.peek();
                Text textNode = this.document.createTextNode(this.textBuffer.toString());
                element.appendChild(textNode);
                this.textBuffer = new StringBuilder();
            }
        }
    }
}

