/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.resources.Resource;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaFilesCache;
import org.sonar.java.bytecode.visitor.ResourceMapping;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class DefaultJavaResourceLocator
implements JavaResourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(JavaResourceLocator.class);
    private final FileSystem fs;
    private final JavaClasspath javaClasspath;
    @VisibleForTesting
    Map<String, Resource> resourcesByClass;
    private final Map<String, String> sourceFileByClass;
    private final Map<String, Integer> methodStartLines;
    private final ResourceMapping resourceMapping;
    private SensorContext sensorContext;

    public DefaultJavaResourceLocator(FileSystem fs, JavaClasspath javaClasspath) {
        this.fs = fs;
        this.javaClasspath = javaClasspath;
        this.resourcesByClass = Maps.newHashMap();
        this.sourceFileByClass = Maps.newHashMap();
        this.methodStartLines = Maps.newHashMap();
        this.resourceMapping = new ResourceMapping();
    }

    public void setSensorContext(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
    }

    @Override
    public Resource findResourceByClassName(String className) {
        String name = className.replace('.', '/');
        Resource resource = this.resourcesByClass.get(name);
        if (resource == null) {
            LOG.debug("Class not found in resource cache : {}", (Object)className);
        }
        return resource;
    }

    @Override
    public String findSourceFileKeyByClassName(String className) {
        String name = className.replace('.', '/');
        return this.sourceFileByClass.get(name);
    }

    @Override
    public Collection<String> classKeys() {
        return ImmutableSortedSet.naturalOrder().addAll(this.resourcesByClass.keySet()).build();
    }

    @Override
    public Collection<File> classFilesToAnalyze() {
        ImmutableList.Builder result = ImmutableList.builder();
        block0: for (String key : this.classKeys()) {
            String filePath = key + ".class";
            for (File binaryDir : this.javaClasspath.getBinaryDirs()) {
                File classFile = new File(binaryDir, filePath);
                if (!classFile.isFile()) continue;
                result.add((Object)classFile);
                continue block0;
            }
        }
        return result.build();
    }

    @Override
    public Collection<File> classpath() {
        return this.javaClasspath.getElements();
    }

    @Override
    public Integer getMethodStartLine(String fullyQualifiedMethodName) {
        return this.methodStartLines.get(fullyQualifiedMethodName);
    }

    @Override
    public ResourceMapping getResourceMapping() {
        return this.resourceMapping;
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        Preconditions.checkNotNull((Object)this.sensorContext);
        JavaFilesCache javaFilesCache = new JavaFilesCache();
        javaFilesCache.scanFile(context);
        InputFile inputFile = this.fs.inputFile(this.fs.predicates().is(context.getFile()));
        org.sonar.api.resources.File currentResource = (org.sonar.api.resources.File)this.sensorContext.getResource((InputPath)inputFile);
        if (currentResource == null) {
            throw new IllegalStateException("resource not found : " + context.getFileKey());
        }
        this.resourceMapping.addResource(currentResource, context.getFileKey());
        for (Map.Entry<String, File> classIOFileEntry : javaFilesCache.getResourcesCache().entrySet()) {
            this.resourcesByClass.put(classIOFileEntry.getKey(), (Resource)currentResource);
            if (context.getFileKey() == null) continue;
            this.sourceFileByClass.put(classIOFileEntry.getKey(), context.getFileKey());
        }
        this.methodStartLines.putAll(javaFilesCache.getMethodStartLines());
    }
}

