/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.source.Highlightable;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaIssue;
import org.sonar.java.JavaTestClasspath;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.squidbridge.api.CodeVisitor;

public class SonarComponents
implements BatchExtension {
    private static final boolean IS_SONARQUBE_52 = SonarComponents.isSonarQube52();
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final JavaTestClasspath javaTestClasspath;
    private final CheckFactory checkFactory;
    private final SensorContext context;
    private final FileSystem fs;
    private final JavaClasspath javaClasspath;
    private final List<Checks<JavaCheck>> checks;
    private final List<Checks<JavaCheck>> testChecks;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, SensorContext context, CheckFactory checkFactory) {
        this(fileLinesContextFactory, resourcePerspectives, fs, javaClasspath, javaTestClasspath, checkFactory, context, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, FileSystem fs, JavaClasspath javaClasspath, JavaTestClasspath javaTestClasspath, CheckFactory checkFactory, SensorContext context, @Nullable CheckRegistrar[] checkRegistrars) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.fs = fs;
        this.javaClasspath = javaClasspath;
        this.javaTestClasspath = javaTestClasspath;
        this.checkFactory = checkFactory;
        this.context = context;
        this.checks = Lists.newArrayList();
        this.testChecks = Lists.newArrayList();
        if (checkRegistrars != null) {
            CheckRegistrar.RegistrarContext registrarContext = new CheckRegistrar.RegistrarContext();
            for (CheckRegistrar checkClassesRegister : checkRegistrars) {
                checkClassesRegister.register(registrarContext);
                ArrayList checkClasses = registrarContext.checkClasses();
                ArrayList testCheckClasses = registrarContext.testCheckClasses();
                this.registerCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList((Iterable)(checkClasses != null ? checkClasses : new ArrayList())));
                this.registerTestCheckClasses(registrarContext.repositoryKey(), Lists.newArrayList((Iterable)(testCheckClasses != null ? testCheckClasses : new ArrayList())));
            }
        }
    }

    public InputFile inputFromIOFile(File file) {
        return this.fs.inputFile(this.fs.predicates().is(file));
    }

    private InputPath inputPathFromIOFile(File file) {
        if (file.isDirectory()) {
            return this.fs.inputDir(file);
        }
        return this.inputFromIOFile(file);
    }

    public FileLinesContext fileLinesContextFor(File file) {
        return this.fileLinesContextFactory.createFor(this.inputFromIOFile(file));
    }

    public Symbolizable symbolizableFor(File file) {
        return (Symbolizable)this.resourcePerspectives.as(Symbolizable.class, (InputPath)this.inputFromIOFile(file));
    }

    public Highlightable highlightableFor(File file) {
        return (Highlightable)this.resourcePerspectives.as(Highlightable.class, (InputPath)this.inputFromIOFile(file));
    }

    public Issuable issuableFor(InputPath inputPath) {
        return (Issuable)this.resourcePerspectives.as(Issuable.class, inputPath);
    }

    public List<File> getJavaClasspath() {
        if (this.javaClasspath == null) {
            return Lists.newArrayList();
        }
        return this.javaClasspath.getElements();
    }

    public List<File> getJavaTestClasspath() {
        return this.javaTestClasspath.getElements();
    }

    public ResourcePerspectives getResourcePerspectives() {
        return this.resourcePerspectives;
    }

    public void registerCheckClasses(String repositoryKey, List<Class<? extends JavaCheck>> checkClasses) {
        this.checks.add((Checks<JavaCheck>)this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses));
    }

    public CodeVisitor[] checkClasses() {
        ArrayList visitors = Lists.newArrayList();
        for (Checks<JavaCheck> checksElement : this.checks) {
            Collection checksCollection = checksElement.all();
            if (checksCollection.isEmpty()) continue;
            visitors.addAll(checksCollection);
        }
        return visitors.toArray(new CodeVisitor[visitors.size()]);
    }

    public Iterable<Checks<JavaCheck>> checks() {
        return Iterables.concat(this.checks, (Iterable)Lists.newArrayList(this.testChecks));
    }

    public void registerTestCheckClasses(String repositoryKey, List<Class<? extends JavaCheck>> checkClasses) {
        this.testChecks.add((Checks<JavaCheck>)this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClasses));
    }

    public Collection<JavaCheck> testCheckClasses() {
        ArrayList visitors = Lists.newArrayList();
        for (Checks<JavaCheck> checksElement : this.testChecks) {
            Collection checksCollection = checksElement.all();
            if (checksCollection.isEmpty()) continue;
            visitors.addAll(checksCollection);
        }
        return visitors;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public RuleKey getRuleKey(JavaCheck check) {
        for (Checks<JavaCheck> sonarChecks : this.checks()) {
            RuleKey ruleKey = sonarChecks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }

    public void addIssue(File file, JavaCheck check, int line, String message, @Nullable Double cost) {
        this.reportIssue(new AnalyzerMessage(check, file, line, message, cost != null ? cost.intValue() : 0));
    }

    public void reportIssue(AnalyzerMessage analyzerMessage) {
        JavaCheck check = analyzerMessage.getCheck();
        Preconditions.checkNotNull((Object)check);
        Preconditions.checkNotNull((Object)analyzerMessage.getMessage());
        RuleKey key = this.getRuleKey(check);
        if (key == null) {
            return;
        }
        File file = analyzerMessage.getFile();
        InputPath inputPath = this.inputPathFromIOFile(file);
        if (inputPath == null) {
            return;
        }
        Double cost = analyzerMessage.getCost();
        if (IS_SONARQUBE_52) {
            this.reportIssueAfterSQ52(analyzerMessage, key, inputPath, cost);
        } else {
            this.reportIssueBeforeSQ52(inputPath, key, cost, analyzerMessage.getMessage(), analyzerMessage.getLine());
        }
    }

    @VisibleForTesting
    void reportIssueAfterSQ52(AnalyzerMessage analyzerMessage, RuleKey key, InputPath inputPath, Double cost) {
        JavaIssue issue = JavaIssue.create((SensorContext)this.context, (RuleKey)key, (Double)cost);
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        if (textSpan == null) {
            issue.setPrimaryLocationOnFile(inputPath, analyzerMessage.getMessage());
        } else {
            issue.setPrimaryLocation((InputFile)inputPath, analyzerMessage.getMessage(), textSpan.startLine, textSpan.startCharacter, textSpan.endLine, textSpan.endCharacter);
        }
        for (AnalyzerMessage location : analyzerMessage.secondaryLocations) {
            AnalyzerMessage.TextSpan secondarySpan = location.primaryLocation();
            issue.addSecondaryLocation(this.inputFromIOFile(location.getFile()), secondarySpan.startLine, secondarySpan.startCharacter, secondarySpan.endLine, secondarySpan.endCharacter, location.getMessage());
        }
        issue.save();
    }

    private void reportIssueBeforeSQ52(InputPath inputFile, RuleKey key, @Nullable Double cost, String message, @Nullable Integer line) {
        Issuable issuable = this.issuableFor(inputFile);
        if (issuable != null) {
            Issuable.IssueBuilder newIssueBuilder = issuable.newIssueBuilder().ruleKey(key).message(message).line(line).effortToFix(cost);
            issuable.addIssue(newIssueBuilder.build());
        }
    }

    private static boolean isSonarQube52() {
        try {
            Issuable.IssueBuilder.class.getMethod("newLocation", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

