/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.Collections;
import org.sonar.java.bytecode.BytecodeVisitorNotifier;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.bytecode.VirtualMethodsLinker;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmClassProvider;
import org.sonar.java.bytecode.asm.AsmClassProviderImpl;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.bytecode.visitor.BytecodeContext;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squidbridge.api.AnalysisException;
import org.sonar.squidbridge.api.CodeScanner;
import org.sonar.squidbridge.api.CodeVisitor;

public class BytecodeScanner
extends CodeScanner<BytecodeVisitor> {
    private final BytecodeContext context;

    public BytecodeScanner(BytecodeContext context) {
        this.context = context;
    }

    public BytecodeScanner scan(Collection<File> bytecodeFilesOrDirectories) {
        ClassLoader classLoader = ClassLoaderBuilder.create(bytecodeFilesOrDirectories);
        this.scanClasses(this.context.getJavaResourceLocator().classKeys(), new AsmClassProviderImpl(classLoader));
        ((SquidClassLoader)classLoader).close();
        return this;
    }

    protected BytecodeScanner scanClasses(Collection<String> classes, AsmClassProvider classProvider) {
        BytecodeScanner.loadByteCodeInformation(classes, classProvider);
        BytecodeScanner.linkVirtualMethods(classes, classProvider);
        this.notifyBytecodeVisitors(classes, classProvider);
        return this;
    }

    private static void linkVirtualMethods(Collection<String> keys, AsmClassProvider classProvider) {
        VirtualMethodsLinker linker = new VirtualMethodsLinker();
        for (String key : keys) {
            AsmClass asmClass = classProvider.getClass(key, AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
            for (AsmMethod method : asmClass.getMethods()) {
                linker.process(method);
            }
        }
    }

    private void notifyBytecodeVisitors(Collection<String> keys, AsmClassProvider classProvider) {
        BytecodeVisitor[] visitorArray;
        for (BytecodeVisitor bytecodeVisitor : visitorArray = this.getVisitors().toArray(new BytecodeVisitor[this.getVisitors().size()])) {
            bytecodeVisitor.setContext(this.context);
        }
        for (String key : keys) {
            try {
                AsmClass asmClass = classProvider.getClass(key, AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
                BytecodeVisitorNotifier visitorNotifier = new BytecodeVisitorNotifier(asmClass, visitorArray);
                visitorNotifier.notifyVisitors();
            }
            catch (Exception exception) {
                BytecodeScanner.checkInterrrupted(exception);
                throw new AnalysisException("Unable to analyze .class file " + key, (Throwable)exception);
            }
        }
    }

    private static void checkInterrrupted(Exception e) {
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", (Throwable)e);
        }
    }

    private static void loadByteCodeInformation(Collection<String> keys, AsmClassProvider classProvider) {
        for (String key : keys) {
            classProvider.getClass(key, AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
        }
    }

    public Collection<Class<? extends BytecodeVisitor>> getVisitorClasses() {
        return Collections.emptyList();
    }

    public void accept(CodeVisitor visitor) {
        if (visitor instanceof BytecodeVisitor) {
            super.accept(visitor);
        }
    }
}

