/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonar.api.design.Dependency;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Resource;

public class ResourceMapping {
    private Multimap<Directory, File> directories = ArrayListMultimap.create();
    private Multimap<Dependency, Dependency> subDependencies = ArrayListMultimap.create();
    private Map<String, File> resourceByfileKey = new HashMap<String, File>();

    public void addResource(File resource, String fileKey) {
        this.directories.put((Object)resource.getParent(), (Object)resource);
        this.resourceByfileKey.put(fileKey, resource);
    }

    public String getComponentKeyByFileKey(String fileKey) {
        return this.resourceByfileKey.get(fileKey).getEffectiveKey();
    }

    public Set<Resource> directories() {
        return ImmutableSortedSet.orderedBy((Comparator)new Comparator<Resource>(){

            @Override
            public int compare(Resource resource, Resource resource2) {
                return resource.getKey().compareTo(resource2.getKey());
            }
        }).addAll((Iterable)this.directories.keySet()).build();
    }

    public Collection<Resource> files(Directory directory) {
        return ImmutableSet.builder().addAll((Iterable)this.directories.get((Object)directory)).build();
    }

    public void addSubDependency(Dependency parent, Dependency subDependency) {
        this.subDependencies.put((Object)parent, (Object)subDependency);
    }

    public Collection<Dependency> getSubDependencies(Dependency parent) {
        return this.subDependencies.get((Object)parent);
    }
}

