/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LocalVariableReadExtractor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class LiveVariables {
    private final CFG cfg;
    private final Map<CFG.Block, Set<Symbol>> out = new HashMap<CFG.Block, Set<Symbol>>();

    private LiveVariables(CFG cfg) {
        this.cfg = cfg;
    }

    public Set<Symbol> getOut(CFG.Block block) {
        return this.out.get(block);
    }

    public static LiveVariables analyze(CFG cfg) {
        LiveVariables liveVariables = new LiveVariables(cfg);
        HashMap<CFG.Block, Set<Symbol>> in = new HashMap<CFG.Block, Set<Symbol>>();
        HashMap<CFG.Block, Set<Symbol>> kill = new HashMap<CFG.Block, Set<Symbol>>();
        HashMap<CFG.Block, Set<Symbol>> gen = new HashMap<CFG.Block, Set<Symbol>>();
        for (CFG.Block block : liveVariables.cfg.reversedBlocks()) {
            HashSet<Symbol> blockKill = new HashSet<Symbol>();
            HashSet<Symbol> blockGen = new HashSet<Symbol>();
            liveVariables.processBlockElements(block, blockKill, blockGen);
            kill.put(block, blockKill);
            gen.put(block, blockGen);
        }
        liveVariables.analyzeCFG(in, kill, gen);
        if (!liveVariables.out.get(liveVariables.cfg.reversedBlocks().get(0)).isEmpty()) {
            throw new IllegalStateException("Out of exit block should be empty");
        }
        for (Map.Entry entry : liveVariables.out.entrySet()) {
            entry.setValue(ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        return liveVariables;
    }

    private void analyzeCFG(Map<CFG.Block, Set<Symbol>> in, Map<CFG.Block, Set<Symbol>> kill, Map<CFG.Block, Set<Symbol>> gen) {
        LinkedList<CFG.Block> workList = new LinkedList<CFG.Block>();
        workList.addAll(this.cfg.reversedBlocks());
        while (!workList.isEmpty()) {
            CFG.Block block = (CFG.Block)workList.removeFirst();
            Set<Symbol> blockOut = this.out.get(block);
            if (blockOut == null) {
                blockOut = new HashSet<Symbol>();
                this.out.put(block, blockOut);
            }
            for (CFG.Block successor : block.successors()) {
                Set<Symbol> inOfSuccessor = in.get(successor);
                if (inOfSuccessor == null) continue;
                blockOut.addAll(inOfSuccessor);
            }
            HashSet newIn = new HashSet(gen.get(block));
            newIn.addAll(Sets.difference(blockOut, kill.get(block)));
            if (newIn.equals(in.get(block))) continue;
            in.put(block, newIn);
            for (CFG.Block predecessor : block.predecessors()) {
                workList.addLast(predecessor);
            }
        }
    }

    private void processBlockElements(CFG.Block block, Set<Symbol> blockKill, Set<Symbol> blockGen) {
        HashSet<ExpressionTree> assignmentLHS = new HashSet<ExpressionTree>();
        for (Tree element : Lists.reverse(block.elements())) {
            switch (element.kind()) {
                case ASSIGNMENT: {
                    Symbol symbol;
                    ExpressionTree lhs = ((AssignmentExpressionTree)element).variable();
                    if (!lhs.is(Tree.Kind.IDENTIFIER) || !LiveVariables.isLocalVariable(symbol = ((IdentifierTree)lhs).symbol())) break;
                    assignmentLHS.add(lhs);
                    blockGen.remove(symbol);
                    blockKill.add(symbol);
                    break;
                }
                case IDENTIFIER: {
                    Symbol symbol = ((IdentifierTree)element).symbol();
                    if (assignmentLHS.contains(element) || !LiveVariables.isLocalVariable(symbol)) break;
                    blockGen.add(symbol);
                    break;
                }
                case VARIABLE: {
                    blockKill.add(((VariableTree)element).symbol());
                    blockGen.remove(((VariableTree)element).symbol());
                    break;
                }
                case LAMBDA_EXPRESSION: {
                    blockGen.addAll(LiveVariables.getUsedVariables(((LambdaExpressionTree)element).body(), this.cfg.methodSymbol()));
                    break;
                }
                case NEW_CLASS: {
                    blockGen.addAll(LiveVariables.getUsedVariables(((NewClassTree)element).classBody(), this.cfg.methodSymbol()));
                    break;
                }
            }
        }
    }

    private static boolean isLocalVariable(Symbol symbol) {
        return symbol.owner().isMethodSymbol();
    }

    private static List<Symbol> getUsedVariables(@Nullable Tree syntaxNode, Symbol.MethodSymbol owner) {
        if (syntaxNode == null) {
            return Collections.emptyList();
        }
        LocalVariableReadExtractor extractorFromClass = new LocalVariableReadExtractor(owner);
        syntaxNode.accept(extractorFromClass);
        return extractorFromClass.usedVariables();
    }
}

