/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

public class LocalVariableReadExtractor
extends BaseTreeVisitor {
    private final Symbol.MethodSymbol methodSymbol;
    private final List<Symbol> used;

    public LocalVariableReadExtractor(Symbol.MethodSymbol methodSymbol) {
        this.methodSymbol = methodSymbol;
        this.used = new ArrayList<Symbol>();
    }

    public List<Symbol> usedVariables() {
        return this.used;
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (!tree.variable().is(Tree.Kind.IDENTIFIER)) {
            this.scan(tree.variable());
        }
        this.scan(tree.expression());
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (this.methodSymbol.equals(tree.symbol().owner())) {
            this.used.add(tree.symbol());
        }
        super.visitIdentifier(tree);
    }
}

