/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaFilesCache;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class DefaultJavaResourceLocator
implements JavaResourceLocator {
    private static final Logger LOG = Loggers.get(JavaResourceLocator.class);
    private final FileSystem fs;
    private final JavaClasspath javaClasspath;
    @VisibleForTesting
    Map<String, InputFile> resourcesByClass;
    private final Map<String, String> sourceFileByClass;
    private final Map<String, Integer> methodStartLines;
    private SensorContext sensorContext;

    public DefaultJavaResourceLocator(FileSystem fs, JavaClasspath javaClasspath) {
        this.fs = fs;
        this.javaClasspath = javaClasspath;
        this.resourcesByClass = Maps.newHashMap();
        this.sourceFileByClass = Maps.newHashMap();
        this.methodStartLines = Maps.newHashMap();
    }

    public void setSensorContext(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
    }

    @Override
    public InputFile findResourceByClassName(String className) {
        String name = className.replace('.', '/');
        InputFile inputFile = this.resourcesByClass.get(name);
        if (inputFile == null) {
            LOG.debug("Class not found in resource cache : {}", (Object)className);
        }
        return inputFile;
    }

    @Override
    public String findSourceFileKeyByClassName(String className) {
        String name = className.replace('.', '/');
        return this.sourceFileByClass.get(name);
    }

    @Override
    public Collection<String> classKeys() {
        return ImmutableSortedSet.naturalOrder().addAll(this.resourcesByClass.keySet()).build();
    }

    @Override
    public Collection<File> classFilesToAnalyze() {
        ImmutableList.Builder result = ImmutableList.builder();
        block0: for (String key : this.classKeys()) {
            String filePath = key + ".class";
            for (File binaryDir : this.javaClasspath.getBinaryDirs()) {
                File classFile = new File(binaryDir, filePath);
                if (!classFile.isFile()) continue;
                result.add((Object)classFile);
                continue block0;
            }
        }
        return result.build();
    }

    @Override
    public Collection<File> classpath() {
        return this.javaClasspath.getElements();
    }

    @Override
    public Integer getMethodStartLine(String fullyQualifiedMethodName) {
        return this.methodStartLines.get(fullyQualifiedMethodName);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        Preconditions.checkNotNull((Object)this.sensorContext);
        JavaFilesCache javaFilesCache = new JavaFilesCache();
        javaFilesCache.scanFile(context);
        InputFile inputFile = this.fs.inputFile(this.fs.predicates().is(context.getFile()));
        if (inputFile == null) {
            throw new IllegalStateException("resource not found : " + context.getFileKey());
        }
        for (Map.Entry<String, File> classIOFileEntry : javaFilesCache.getResourcesCache().entrySet()) {
            this.resourcesByClass.put(classIOFileEntry.getKey(), inputFile);
            if (context.getFileKey() == null) continue;
            this.sourceFileByClass.put(classIOFileEntry.getKey(), context.getFileKey());
        }
        this.methodStartLines.putAll(javaFilesCache.getMethodStartLines());
    }
}

