/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.sslr.grammar.GrammarRuleKey;

public abstract class ListTreeImpl<T extends Tree>
extends JavaTree
implements ListTree<T> {
    private final List<T> list;
    private final List<SyntaxToken> separators;

    public ListTreeImpl(GrammarRuleKey grammarRuleKey, List<T> list) {
        super(grammarRuleKey);
        this.list = list;
        this.separators = Lists.newArrayList();
    }

    public ListTreeImpl(GrammarRuleKey grammarRuleKey, List<T> list, List<SyntaxToken> separators) {
        super(grammarRuleKey);
        this.list = list;
        this.separators = separators;
    }

    @Override
    public List<SyntaxToken> separators() {
        return this.separators;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        for (Tree t : this.list) {
            t.accept(visitor);
        }
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.LIST;
    }

    @Override
    public Iterable<Tree> children() {
        return new InterleaveIterable(this.list, this.separators);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T get(int index) {
        return (T)((Tree)this.list.get(index));
    }

    @Override
    public T set(int index, T element) {
        return (T)((Tree)this.list.set(index, element));
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public T remove(int index) {
        return (T)((Tree)this.list.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    private static class InterleaveIterator<E>
    extends AbstractIterator<E> {
        private final LinkedList<Iterator<? extends E>> iterables;

        public InterleaveIterator(List<Iterator<? extends E>> iterables) {
            this.iterables = new LinkedList<Iterator<Iterator<? extends E>>>(iterables);
        }

        protected E computeNext() {
            while (!this.iterables.isEmpty()) {
                Iterator<E> topIter = this.iterables.poll();
                if (!topIter.hasNext()) continue;
                E result = topIter.next();
                this.iterables.offer(topIter);
                return result;
            }
            return (E)this.endOfData();
        }
    }

    private class InterleaveIterable
    implements Iterable<Tree> {
        private final ImmutableList<Iterator<? extends Tree>> iterators;

        public InterleaveIterable(List<T> list, List<SyntaxToken> separators) {
            this.iterators = ImmutableList.of(list.iterator(), separators.iterator());
        }

        @Override
        public Iterator<Tree> iterator() {
            return new InterleaveIterator<Tree>((List<Iterator<? extends Tree>>)this.iterators);
        }
    }
}

