/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeContext;
import org.sonar.java.signature.MethodSignature;
import org.sonar.java.signature.MethodSignaturePrinter;
import org.sonar.java.signature.MethodSignatureScanner;
import org.sonar.plugins.java.api.JavaCheck;

public abstract class BytecodeVisitor
implements JavaCheck {
    BytecodeContext context;

    public void visitClass(AsmClass asmClass) {
    }

    public void visitMethod(AsmMethod asmMethod) {
    }

    public void visitField(AsmField asmField) {
    }

    public void visitEdge(AsmEdge asmEdge) {
    }

    public void leaveClass(AsmClass asmClass) {
    }

    public void setContext(BytecodeContext context) {
        this.context = context;
    }

    protected BytecodeContext getContext() {
        return this.context;
    }

    @Nullable
    protected final InputFile getSourceFile(AsmClass asmClass) {
        return this.context.getJavaResourceLocator().findResourceByClassName(asmClass.getInternalName());
    }

    protected final int getMethodLineNumber(AsmMethod asmMethod) {
        MethodSignature methodSignature = MethodSignatureScanner.scan(asmMethod.getGenericKey());
        AsmClass asmClass = asmMethod.getParent();
        Integer result = this.context.getJavaResourceLocator().getMethodStartLine(asmClass.getInternalName() + "#" + MethodSignaturePrinter.print(methodSignature));
        if (result != null) {
            return result;
        }
        return -1;
    }
}

