/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.ComplexityVisitor;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class DefaultJavaFileScannerContext
implements JavaFileScannerContext {
    private final CompilationUnitTree tree;
    @VisibleForTesting
    private final SemanticModel semanticModel;
    private final SonarComponents sonarComponents;
    private final ComplexityVisitor complexityVisitor;
    private final File file;
    private final JavaVersion javaVersion;
    private final boolean fileParsed;

    public DefaultJavaFileScannerContext(CompilationUnitTree tree, File file, SemanticModel semanticModel, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean fileParsed) {
        this.tree = tree;
        this.file = file;
        this.semanticModel = semanticModel;
        this.sonarComponents = sonarComponents;
        this.complexityVisitor = new ComplexityVisitor();
        this.javaVersion = javaVersion;
        this.fileParsed = fileParsed;
    }

    @Override
    public CompilationUnitTree getTree() {
        return this.tree;
    }

    @Override
    public void addIssueOnFile(JavaCheck javaCheck, String message) {
        this.addIssue(-1, javaCheck, message);
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message) {
        this.addIssue(line, javaCheck, message, null);
    }

    @Override
    public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Integer cost) {
        this.sonarComponents.addIssue(this.file, javaCheck, line, message, cost);
    }

    @Override
    @Nullable
    public Object getSemanticModel() {
        return this.semanticModel;
    }

    @Override
    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public boolean fileParsed() {
        return this.fileParsed;
    }

    @Override
    public String getFileKey() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void addIssue(File file, JavaCheck check, int line, String message) {
        if (this.sonarComponents != null) {
            this.sonarComponents.addIssue(file, check, line, message, null);
        }
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree tree, String message) {
        this.reportIssue(javaCheck, tree, message, (List<JavaFileScannerContext.Location>)ImmutableList.of(), null);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        this.sonarComponents.reportIssue(DefaultJavaFileScannerContext.createAnalyzerMessage(this.file, javaCheck, syntaxNode, null, message, secondary, cost));
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message) {
        this.reportIssue(javaCheck, startTree, endTree, message, (List<JavaFileScannerContext.Location>)ImmutableList.of(), null);
    }

    @Override
    public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        this.sonarComponents.reportIssue(DefaultJavaFileScannerContext.createAnalyzerMessage(this.file, javaCheck, startTree, endTree, message, secondary, cost));
    }

    protected static AnalyzerMessage createAnalyzerMessage(File file, JavaCheck javaCheck, Tree startTree, @Nullable Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
        AnalyzerMessage.TextSpan textSpan = endTree != null ? AnalyzerMessage.textSpanBetween(startTree, endTree) : AnalyzerMessage.textSpanFor(startTree);
        AnalyzerMessage analyzerMessage = new AnalyzerMessage(javaCheck, file, textSpan, message, cost != null ? cost : 0);
        for (JavaFileScannerContext.Location location : secondary) {
            AnalyzerMessage secondaryLocation = new AnalyzerMessage(javaCheck, file, AnalyzerMessage.textSpanFor(location.syntaxNode), location.msg, 0);
            analyzerMessage.secondaryLocations.add(secondaryLocation);
        }
        return analyzerMessage;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public List<Tree> getComplexityNodes(Tree tree) {
        return this.complexityVisitor.scan(tree);
    }

    @Override
    public List<Tree> getMethodComplexityNodes(ClassTree enclosingClass, MethodTree methodTree) {
        return this.getComplexityNodes(this.tree);
    }
}

