/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S3518")
public class DivisionByZeroCheck
extends SECheck {
    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitLiteral(LiteralTree tree) {
            String value = tree.value();
            SymbolicValue sv = this.programState.peekValue();
            if (tree.is(Tree.Kind.CHAR_LITERAL) && PostStatementVisitor.isNullCharacter(value)) {
                this.addZeroConstraint(sv, tree, Status.ZERO);
            } else if (tree.is(Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL)) {
                this.addZeroConstraint(sv, tree, PostStatementVisitor.isNumberZero(value) ? Status.ZERO : Status.NON_ZERO);
            }
        }

        private static boolean isNumberZero(String literalValue) {
            return !literalValue.matches("(.)*[1-9]+(.)*") && !literalValue.matches("(0x|0X){1}(.)*[1-9a-fA-F]+(.)*") && !literalValue.matches("(0b|0B){1}(.)*[1]+(.)*");
        }

        private static boolean isNullCharacter(String literalValue) {
            return "'\\0'".equals(literalValue) || "'\\u0000'".equals(literalValue);
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            this.checkDeferredConstraint(tree);
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkDeferredConstraint(tree);
        }

        @Override
        public void visitUnaryExpression(UnaryExpressionTree tree) {
            this.checkDeferredConstraint(tree);
        }

        @Override
        public void visitTypeCast(TypeCastTree tree) {
            this.checkDeferredConstraint(tree);
        }

        private void checkDeferredConstraint(Tree tree) {
            SymbolicValue sv = this.programState.peekValue();
            if (sv instanceof DeferredStatusHolderSV) {
                this.addZeroConstraint(sv, tree, ((DeferredStatusHolderSV)sv).deferredStatus);
            }
        }

        private void addZeroConstraint(SymbolicValue sv, Tree tree, Status status) {
            this.programState = this.programState.addConstraint(sv, new ZeroConstraint(tree, status));
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final ConstraintManager constraintManager;
        private final CheckerContext context;

        PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
            this.constraintManager = context.getConstraintManager();
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
            SymbolicValue var = symbolicValues.get(0);
            SymbolicValue expr = symbolicValues.get(1);
            this.checkExpression(tree, var, expr);
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            switch (tree.kind()) {
                case MULTIPLY: 
                case PLUS: 
                case MINUS: 
                case DIVIDE: 
                case REMAINDER: {
                    List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
                    this.checkExpression(tree, symbolicValues.get(1), symbolicValues.get(0));
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL_TO: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL_TO: {
                    List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
                    this.setAsUndetermined(symbolicValues.get(1), tree.leftOperand());
                    this.setAsUndetermined(symbolicValues.get(0), tree.rightOperand());
                    break;
                }
            }
        }

        private void setAsUndetermined(SymbolicValue sv, Tree tree) {
            this.programState = this.programState.addConstraint(sv, new ZeroConstraint(tree, Status.UNDETERMINED));
        }

        private void checkExpression(Tree tree, SymbolicValue leftOp, SymbolicValue rightOp) {
            switch (tree.kind()) {
                case MULTIPLY: 
                case MULTIPLY_ASSIGNMENT: {
                    this.handleMultiply(leftOp, rightOp);
                    break;
                }
                case PLUS: 
                case MINUS: 
                case PLUS_ASSIGNMENT: 
                case MINUS_ASSIGNMENT: {
                    this.handlePlusMinus(leftOp, rightOp);
                    break;
                }
                case DIVIDE: 
                case REMAINDER: 
                case DIVIDE_ASSIGNMENT: 
                case REMAINDER_ASSIGNMENT: {
                    this.handleDivide(tree, leftOp, rightOp);
                    break;
                }
            }
        }

        private boolean isZero(SymbolicValue symbolicValue) {
            return this.hasStatus(symbolicValue, Status.ZERO);
        }

        private boolean isNonZero(SymbolicValue symbolicValue) {
            return this.hasStatus(symbolicValue, Status.NON_ZERO);
        }

        private boolean hasStatus(SymbolicValue symbolicValue, Status status) {
            return this.programState.getConstraintWithStatus(symbolicValue, (Object)status) != null;
        }

        private void handleMultiply(SymbolicValue left, SymbolicValue right) {
            boolean leftIsZero = this.isZero(left);
            if (leftIsZero || this.isZero(right)) {
                this.reuseSymbolicValue(leftIsZero ? left : right);
            } else if (this.isNonZero(left) && this.isNonZero(right)) {
                this.deferConstraint(Status.NON_ZERO);
            }
        }

        private void handlePlusMinus(SymbolicValue left, SymbolicValue right) {
            boolean leftIsZero = this.isZero(left);
            if (leftIsZero || this.isZero(right)) {
                this.reuseSymbolicValue(leftIsZero ? right : left);
            }
        }

        private void handleDivide(Tree tree, SymbolicValue leftOp, SymbolicValue rightOp) {
            if (this.isZero(rightOp)) {
                this.reportIssue(tree);
            } else if (this.isZero(leftOp)) {
                this.reuseSymbolicValue(leftOp);
            } else if (this.isNonZero(leftOp) && this.isNonZero(rightOp)) {
                this.deferConstraint(tree.is(Tree.Kind.DIVIDE, Tree.Kind.DIVIDE_ASSIGNMENT) ? Status.NON_ZERO : Status.UNDETERMINED);
            }
        }

        private void deferConstraint(Status status) {
            this.constraintManager.setValueFactory((id, node) -> new DeferredStatusHolderSV(id, status));
        }

        private void reuseSymbolicValue(SymbolicValue sv) {
            this.constraintManager.setValueFactory((id, node) -> sv);
        }

        private void reportIssue(Tree tree) {
            ExpressionTree expression = this.getDenominator(tree);
            String operation = tree.is(Tree.Kind.REMAINDER, Tree.Kind.REMAINDER_ASSIGNMENT) ? "modulation" : "division";
            String expressionName = expression.is(Tree.Kind.IDENTIFIER) ? "'" + ((IdentifierTree)expression).name() + "'" : "this expression";
            this.context.reportIssue(expression, DivisionByZeroCheck.this, "Make sure " + expressionName + " can't be zero before doing this " + operation + ".");
            this.programState = null;
        }

        private ExpressionTree getDenominator(Tree tree) {
            return tree.is(Tree.Kind.DIVIDE, Tree.Kind.REMAINDER) ? ((BinaryExpressionTree)tree).rightOperand() : ((AssignmentExpressionTree)tree).expression();
        }

        @Override
        public void visitTypeCast(TypeCastTree tree) {
            Type type = tree.type().symbolType();
            if (type.isPrimitive()) {
                SymbolicValue sv = this.programState.peekValue();
                if (this.isZero(sv)) {
                    this.reuseSymbolicValue(sv);
                } else if (this.isNonZero(sv)) {
                    this.deferConstraint(Status.NON_ZERO);
                }
            }
        }

        @Override
        public void visitUnaryExpression(UnaryExpressionTree tree) {
            if (!tree.is(Tree.Kind.LOGICAL_COMPLEMENT)) {
                SymbolicValue sv = this.programState.peekValue();
                if (this.isZero(sv)) {
                    if (tree.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
                        this.reuseSymbolicValue(sv);
                    } else {
                        this.deferConstraint(Status.NON_ZERO);
                    }
                } else {
                    this.deferConstraint(Status.UNDETERMINED);
                }
            }
        }
    }

    private static class ZeroConstraint
    extends ObjectConstraint {
        private ZeroConstraint(Tree syntaxNode, Status status) {
            super(false, false, syntaxNode, (Object)status);
        }

        @Override
        public boolean isInvalidWith(@Nullable Constraint constraint) {
            return this.hasStatus((Object)Status.ZERO) && constraint instanceof ObjectConstraint && ((ObjectConstraint)constraint).hasStatus((Object)Status.ZERO);
        }
    }

    private static class DeferredStatusHolderSV
    extends SymbolicValue {
        private final Status deferredStatus;

        public DeferredStatusHolderSV(int id, Status deferredStatus) {
            super(id);
            this.deferredStatus = deferredStatus;
        }
    }

    private static enum Status {
        ZERO,
        NON_ZERO,
        UNDETERMINED;

    }
}

