/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.EmptyStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class StatementVisitor
extends BaseTreeVisitor {
    private int statements;
    private Set<Tree> variableTypes = new HashSet<Tree>();

    public int numberOfStatements(Tree tree) {
        this.statements = 0;
        this.variableTypes.clear();
        this.scan(tree);
        this.statements += this.variableTypes.size();
        return this.statements;
    }

    @Override
    public void visitEmptyStatement(EmptyStatementTree tree) {
        ++this.statements;
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        ++this.statements;
        super.visitIfStatement(tree);
    }

    @Override
    public void visitAssertStatement(AssertStatementTree tree) {
        ++this.statements;
        super.visitAssertStatement(tree);
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        ++this.statements;
        super.visitSwitchStatement(tree);
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        ++this.statements;
        super.visitWhileStatement(tree);
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        ++this.statements;
        super.visitDoWhileStatement(tree);
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        ++this.statements;
        super.visitForStatement(tree);
        this.removeVariable(tree.initializer());
        this.removeVariable(tree.update());
    }

    private void removeVariable(List<StatementTree> statementTrees) {
        for (StatementTree statementTree : statementTrees) {
            if (statementTree.is(Tree.Kind.VARIABLE)) {
                this.variableTypes.remove(((VariableTree)statementTree).type());
                continue;
            }
            --this.statements;
        }
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        ++this.statements;
        super.visitForEachStatement(tree);
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        ++this.statements;
        super.visitBreakStatement(tree);
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        ++this.statements;
        super.visitContinueStatement(tree);
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        ++this.statements;
        super.visitReturnStatement(tree);
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        ++this.statements;
        super.visitThrowStatement(tree);
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
        ++this.statements;
        super.visitSynchronizedStatement(tree);
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        ++this.statements;
        this.statements -= tree.resources().size();
        this.statements -= tree.catches().size();
        super.visitTryStatement(tree);
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.variableTypes.add(tree.type());
        super.visitVariable(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        for (VariableTree variableTree : tree.parameters()) {
            this.variableTypes.remove(variableTree.type());
        }
    }

    @Override
    public void visitClass(ClassTree tree) {
        super.visitClass(tree);
        for (Tree member : tree.members()) {
            if (!member.is(Tree.Kind.VARIABLE)) continue;
            this.variableTypes.remove(((VariableTree)member).type());
        }
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ++this.statements;
        super.visitExpressionStatement(tree);
    }
}

