/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.cfg;

import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

public class VariableReadExtractor
extends BaseTreeVisitor {
    private final Symbol.MethodSymbol methodSymbol;
    private final Set<Symbol> used;
    private final boolean includeFields;

    public VariableReadExtractor(Symbol.MethodSymbol methodSymbol, boolean includeFields) {
        this.methodSymbol = methodSymbol;
        this.includeFields = includeFields;
        this.used = new HashSet<Symbol>();
    }

    public Set<Symbol> usedVariables() {
        return this.used;
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (!tree.variable().is(Tree.Kind.IDENTIFIER) && !tree.variable().is(Tree.Kind.MEMBER_SELECT)) {
            this.scan(tree.variable());
        }
        this.scan(tree.expression());
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        Symbol owner = tree.symbol().owner();
        if (this.methodSymbol.equals(owner) || this.includeFields && VariableReadExtractor.isField(tree.symbol(), this.methodSymbol.owner())) {
            this.used.add(tree.symbol());
        }
        super.visitIdentifier(tree);
    }

    private static boolean isField(Symbol identifierSymbol, Symbol methodOwnerSymbol) {
        return methodOwnerSymbol.equals(identifierSymbol.owner()) && !"this".equals(identifierSymbol.name());
    }
}

