/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.matcher;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;

public class MethodMatcherCollection {
    private List<MethodMatcher> matchers = Lists.newLinkedList();

    private MethodMatcherCollection() {
    }

    public static MethodMatcherCollection create(MethodMatcher ... matchers) {
        MethodMatcherCollection collection = new MethodMatcherCollection();
        Collections.addAll(collection.matchers, matchers);
        return collection;
    }

    public MethodMatcherCollection add(MethodMatcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public boolean anyMatch(MethodInvocationTree mit) {
        for (MethodMatcher matcher : this.matchers) {
            if (!matcher.matches(mit)) continue;
            return true;
        }
        return false;
    }

    public boolean anyMatch(MethodTree method) {
        for (MethodMatcher matcher : this.matchers) {
            if (!matcher.matches(method)) continue;
            return true;
        }
        return false;
    }

    public boolean anyMatch(NewClassTree newClassTree) {
        for (MethodMatcher matcher : this.matchers) {
            if (!matcher.matches(newClassTree)) continue;
            return true;
        }
        return false;
    }
}

