/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.EqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanRelation;
import org.sonar.java.se.symbolicvalues.LessThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.MethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class NotMethodEqualsRelation
extends BinaryRelation {
    NotMethodEqualsRelation(SymbolicValue v1, SymbolicValue v2) {
        super(RelationalSymbolicValue.Kind.NOT_METHOD_EQUALS, v1, v2);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('!');
        buffer.append(this.leftOp);
        buffer.append(".equals(");
        buffer.append(this.rightOp);
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    @CheckForNull
    protected RelationState isImpliedBy(BinaryRelation relation) {
        return relation.impliesNotMethodEquals();
    }

    @Override
    protected RelationState impliesEqual() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesNotEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesMethodEquals() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesNotMethodEquals() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThan() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesGreaterThanOrEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesLessThan() {
        return RelationState.UNDETERMINED;
    }

    @Override
    protected RelationState impliesLessThanOrEqual() {
        return RelationState.UNDETERMINED;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedAfter(BinaryRelation relation) {
        return this.combinedWithNotMethodEquals(this);
    }

    @Override
    protected BinaryRelation combinedWithEqual(EqualRelation relation) {
        return NotMethodEqualsRelation.binaryRelation(RelationalSymbolicValue.Kind.NOT_METHOD_EQUALS, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithNotEqual(NotEqualRelation relation) {
        return null;
    }

    @Override
    protected BinaryRelation combinedWithMethodEquals(MethodEqualsRelation relation) {
        return NotMethodEqualsRelation.binaryRelation(RelationalSymbolicValue.Kind.NOT_METHOD_EQUALS, this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotMethodEquals(NotMethodEqualsRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithGreaterThan(GreaterThanRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithGreaterThanOrEqual(GreaterThanOrEqualRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithLessThan(LessThanRelation relation) {
        return null;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithLessThanOrEqual(LessThanOrEqualRelation relation) {
        return null;
    }

    @Override
    protected BinaryRelation conjunction(BinaryRelation relation) {
        Preconditions.checkArgument((this.leftOp.equals(relation.leftOp) && this.rightOp.equals(relation.rightOp) ? 1 : 0) != 0, (Object)"Conjunction condition not matched!");
        switch (relation.kind) {
            case LESS_THAN_OR_EQUAL: {
                return NotMethodEqualsRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN, this.leftOp, this.rightOp);
            }
            case GREATER_THAN_OR_EQUAL: {
                return NotMethodEqualsRelation.binaryRelation(RelationalSymbolicValue.Kind.GREATER_THAN, this.leftOp, this.rightOp);
            }
        }
        return super.conjunction(relation);
    }
}

