/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;

public class VisitorsBridgeForTests
extends VisitorsBridge {
    private TestJavaFileScannerContext testContext;
    private boolean enableSemantic = true;

    @VisibleForTesting
    public VisitorsBridgeForTests(JavaFileScanner visitor) {
        this(Collections.singletonList(visitor), new ArrayList<File>(), null);
    }

    public VisitorsBridgeForTests(Iterable visitors) {
        this(visitors, new ArrayList<File>(), null, false);
        this.enableSemantic = false;
    }

    public VisitorsBridgeForTests(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        this(visitors, projectClasspath, sonarComponents, true);
    }

    public VisitorsBridgeForTests(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents, boolean symbolicExecutionEnabled) {
        super(visitors, projectClasspath, sonarComponents, symbolicExecutionEnabled);
    }

    @Override
    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, SemanticModel semanticModel, SonarComponents sonarComponents, boolean failedParsing) {
        SemanticModel model = this.enableSemantic ? semanticModel : null;
        this.testContext = new TestJavaFileScannerContext(tree, this.currentFile, model, sonarComponents, this.javaVersion, failedParsing);
        return this.testContext;
    }

    public TestJavaFileScannerContext lastCreatedTestContext() {
        return this.testContext;
    }

    public static class TestJavaFileScannerContext
    extends DefaultJavaFileScannerContext {
        private final Set<AnalyzerMessage> issues = new HashSet<AnalyzerMessage>();

        public TestJavaFileScannerContext(CompilationUnitTree tree, File file, SemanticModel semanticModel, @Nullable SonarComponents sonarComponents, JavaVersion javaVersion, boolean failedParsing) {
            super(tree, file, semanticModel, sonarComponents, javaVersion, failedParsing);
        }

        public Set<AnalyzerMessage> getIssues() {
            return this.issues;
        }

        @Override
        public void addIssue(int line, JavaCheck javaCheck, String message, @Nullable Integer cost) {
            this.issues.add(new AnalyzerMessage(javaCheck, this.getFile(), line, message, cost != null ? cost : 0));
        }

        @Override
        public void reportIssue(JavaCheck javaCheck, Tree syntaxNode, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
            this.issues.add(this.createAnalyzerMessage(javaCheck, syntaxNode, null, message, secondary, cost));
        }

        @Override
        public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message) {
            this.issues.add(this.createAnalyzerMessage(javaCheck, startTree, endTree, message, (List<JavaFileScannerContext.Location>)ImmutableList.of(), null));
        }

        @Override
        public void reportIssue(JavaCheck javaCheck, Tree startTree, Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
            this.issues.add(this.createAnalyzerMessage(javaCheck, startTree, endTree, message, secondary, cost));
        }

        private AnalyzerMessage createAnalyzerMessage(JavaCheck javaCheck, Tree startTree, @Nullable Tree endTree, String message, List<JavaFileScannerContext.Location> secondary, @Nullable Integer cost) {
            return TestJavaFileScannerContext.createAnalyzerMessage(this.getFile(), javaCheck, startTree, endTree, message, secondary, cost);
        }
    }
}

