/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;

public class ParametrizedTypeCache {
    private Map<JavaSymbol, Map<TypeSubstitution, ParametrizedTypeJavaType>> typeCache = Maps.newHashMap();
    private Map<JavaType, Map<WildCardType.BoundType, WildCardType>> wildcardCache = Maps.newHashMap();

    public JavaType getParametrizedTypeType(JavaSymbol.TypeJavaSymbol symbol, TypeSubstitution typeSubstitution) {
        TypeSubstitution newSubstitution;
        if (symbol.getType().isUnknown()) {
            return symbol.getType();
        }
        if (this.typeCache.get(symbol) == null) {
            HashMap map = Maps.newHashMap();
            this.typeCache.put(symbol, map);
        }
        if ((newSubstitution = typeSubstitution).size() == 0) {
            newSubstitution = ParametrizedTypeCache.identitySubstitution(symbol.typeVariableTypes);
        }
        if (this.typeCache.get(symbol).get(newSubstitution) == null) {
            this.typeCache.get(symbol).put(newSubstitution, new ParametrizedTypeJavaType(symbol, newSubstitution));
        }
        return this.typeCache.get(symbol).get(newSubstitution);
    }

    private static TypeSubstitution identitySubstitution(List<TypeVariableJavaType> typeVariables) {
        TypeSubstitution result = new TypeSubstitution();
        for (TypeVariableJavaType typeVar : typeVariables) {
            result.add(typeVar, typeVar);
        }
        return result;
    }

    public JavaType getWildcardType(JavaType bound, WildCardType.BoundType boundType) {
        WildCardType wildcardType;
        Map<WildCardType.BoundType, WildCardType> map = this.wildcardCache.get(bound);
        if (map == null) {
            map = new EnumMap<WildCardType.BoundType, WildCardType>(WildCardType.BoundType.class);
            this.wildcardCache.put(bound, map);
        }
        if ((wildcardType = map.get((Object)boundType)) == null) {
            wildcardType = new WildCardType(bound, boundType);
            map.put(boundType, wildcardType);
        }
        return wildcardType;
    }
}

