/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.DeferredType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.UnknownType;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;

public class Symbols {
    static final JavaSymbol.PackageJavaSymbol rootPackage = new JavaSymbol.PackageJavaSymbol("", null);
    final JavaSymbol.PackageJavaSymbol defaultPackage = new JavaSymbol.PackageJavaSymbol("", rootPackage);
    final JavaSymbol.TypeJavaSymbol predefClass = new JavaSymbol.TypeJavaSymbol(1, "", rootPackage);
    static final UnknownType unknownType;
    public static final JavaSymbol.TypeJavaSymbol unknownSymbol;
    public static final JavaSymbol.MethodJavaSymbol unknownMethodSymbol;
    final JavaSymbol.TypeJavaSymbol arrayClass;
    final JavaSymbol.TypeJavaSymbol methodClass;
    final JavaSymbol.TypeJavaSymbol noSymbol;
    final JavaType byteType;
    final JavaType charType;
    final JavaType shortType;
    final JavaType intType;
    final JavaType longType;
    final JavaType floatType;
    final JavaType doubleType;
    final JavaType booleanType;
    final JavaType nullType;
    final JavaType voidType;
    final BiMap<JavaType, JavaType> boxedTypes;
    final JavaType objectType;
    final JavaType cloneableType;
    final JavaType serializableType;
    final JavaType classType;
    final JavaType stringType;
    final WildCardType unboundedWildcard;
    final JavaType annotationType;
    final JavaType enumType;

    public Symbols(BytecodeCompleter bytecodeCompleter) {
        this.predefClass.members = new Scope(this.predefClass);
        ((ClassJavaType)this.predefClass.type).interfaces = ImmutableList.of();
        this.noSymbol = new JavaSymbol.TypeJavaSymbol(0, "", rootPackage);
        this.methodClass = new JavaSymbol.TypeJavaSymbol(1, "", this.noSymbol);
        this.byteType = this.initType(1, "byte");
        this.charType = this.initType(2, "char");
        this.shortType = this.initType(3, "short");
        this.intType = this.initType(4, "int");
        this.longType = this.initType(5, "long");
        this.floatType = this.initType(6, "float");
        this.doubleType = this.initType(7, "double");
        this.booleanType = this.initType(8, "boolean");
        this.nullType = this.initType(13, "<nulltype>");
        this.voidType = this.initType(9, "void");
        bytecodeCompleter.init(this);
        JavaSymbol.PackageJavaSymbol javalang = bytecodeCompleter.enterPackage("java.lang");
        javalang.members = new Scope.StarImportScope(javalang, bytecodeCompleter);
        javalang.members.enter(javalang);
        this.objectType = bytecodeCompleter.loadClass((String)"java.lang.Object").type;
        this.classType = bytecodeCompleter.loadClass((String)"java.lang.Class").type;
        this.stringType = bytecodeCompleter.loadClass((String)"java.lang.String").type;
        this.cloneableType = bytecodeCompleter.loadClass((String)"java.lang.Cloneable").type;
        this.serializableType = bytecodeCompleter.loadClass((String)"java.io.Serializable").type;
        this.annotationType = bytecodeCompleter.loadClass((String)"java.lang.annotation.Annotation").type;
        this.enumType = bytecodeCompleter.loadClass((String)"java.lang.Enum").type;
        this.unboundedWildcard = new WildCardType(this.objectType, WildCardType.BoundType.UNBOUNDED);
        this.boxedTypes = HashBiMap.create();
        this.boxedTypes.put((Object)this.byteType, (Object)bytecodeCompleter.loadClass((String)"java.lang.Byte").type);
        this.boxedTypes.put((Object)this.charType, (Object)bytecodeCompleter.loadClass((String)"java.lang.Character").type);
        this.boxedTypes.put((Object)this.shortType, (Object)bytecodeCompleter.loadClass((String)"java.lang.Short").type);
        this.boxedTypes.put((Object)this.intType, (Object)bytecodeCompleter.loadClass((String)"java.lang.Integer").type);
        this.boxedTypes.put((Object)this.longType, (Object)bytecodeCompleter.loadClass((String)"java.lang.Long").type);
        this.boxedTypes.put((Object)this.floatType, (Object)bytecodeCompleter.loadClass((String)"java.lang.Float").type);
        this.boxedTypes.put((Object)this.doubleType, (Object)bytecodeCompleter.loadClass((String)"java.lang.Double").type);
        this.boxedTypes.put((Object)this.booleanType, (Object)bytecodeCompleter.loadClass((String)"java.lang.Boolean").type);
        for (Map.Entry entry : this.boxedTypes.entrySet()) {
            ((JavaType)entry.getKey()).primitiveWrapperType = (JavaType)entry.getValue();
            ((JavaType)entry.getValue()).primitiveType = (JavaType)entry.getKey();
        }
        this.arrayClass = new JavaSymbol.TypeJavaSymbol(1, "Array", this.noSymbol);
        ClassJavaType arrayClassType = (ClassJavaType)this.arrayClass.type;
        arrayClassType.supertype = this.objectType;
        arrayClassType.interfaces = ImmutableList.of((Object)this.cloneableType, (Object)this.serializableType);
        this.arrayClass.members = new Scope(this.arrayClass);
        this.arrayClass.members().enter(new JavaSymbol.VariableJavaSymbol(17, "length", this.intType, (JavaSymbol)this.arrayClass));
        this.enterOperators();
    }

    private JavaType initType(int tag, String name) {
        JavaSymbol.TypeJavaSymbol symbol = new JavaSymbol.TypeJavaSymbol(1, name, rootPackage);
        symbol.members = new Scope(symbol);
        this.predefClass.members.enter(symbol);
        ((ClassJavaType)symbol.type).interfaces = ImmutableList.of();
        symbol.type.tag = tag;
        return symbol.type;
    }

    private void enterOperators() {
        for (String op : new String[]{"+", "-", "*", "/", "%"}) {
            for (JavaType type : Arrays.asList(this.doubleType, this.floatType, this.longType, this.intType)) {
                this.enterBinop(op, type, type, type);
            }
        }
        for (String op : new String[]{"&", "|", "^"}) {
            for (JavaType type : Arrays.asList(this.booleanType, this.longType, this.intType)) {
                this.enterBinop(op, type, type, type);
            }
        }
        for (String op : new String[]{"<<", ">>", ">>>"}) {
            this.enterBinop(op, this.longType, this.longType, this.longType);
            this.enterBinop(op, this.intType, this.longType, this.intType);
            this.enterBinop(op, this.longType, this.intType, this.longType);
            this.enterBinop(op, this.intType, this.intType, this.intType);
        }
        for (String op : new String[]{"<", ">", ">=", "<="}) {
            for (JavaType type : Arrays.asList(this.doubleType, this.floatType, this.longType, this.intType)) {
                this.enterBinop(op, type, type, this.booleanType);
            }
        }
        for (String op : new String[]{"==", "!="}) {
            for (JavaType type : Arrays.asList(this.objectType, this.booleanType, this.doubleType, this.floatType, this.longType, this.intType)) {
                this.enterBinop(op, type, type, this.booleanType);
            }
        }
        this.enterBinop("&&", this.booleanType, this.booleanType, this.booleanType);
        this.enterBinop("||", this.booleanType, this.booleanType, this.booleanType);
        for (JavaType type : Arrays.asList(this.nullType, this.objectType, this.booleanType, this.doubleType, this.floatType, this.longType, this.intType)) {
            this.enterBinop("+", this.stringType, type, this.stringType);
            this.enterBinop("+", type, this.stringType, this.stringType);
        }
        this.enterBinop("+", this.stringType, this.stringType, this.stringType);
    }

    private void enterBinop(String name, JavaType left, JavaType right, JavaType result) {
        MethodJavaType type = new MethodJavaType((List<JavaType>)ImmutableList.of((Object)left, (Object)right), result, (List<JavaType>)ImmutableList.of(), this.methodClass);
        JavaSymbol.MethodJavaSymbol symbol = new JavaSymbol.MethodJavaSymbol(9, name, type, (JavaSymbol)this.predefClass);
        this.predefClass.members.enter(symbol);
    }

    public JavaType getPrimitiveFromDescriptor(char descriptor) {
        switch (descriptor) {
            case 'S': {
                return this.shortType;
            }
            case 'I': {
                return this.intType;
            }
            case 'C': {
                return this.charType;
            }
            case 'Z': {
                return this.booleanType;
            }
            case 'B': {
                return this.byteType;
            }
            case 'J': {
                return this.longType;
            }
            case 'F': {
                return this.floatType;
            }
            case 'D': {
                return this.doubleType;
            }
            case 'V': {
                return this.voidType;
            }
        }
        throw new IllegalStateException("Descriptor '" + descriptor + "' cannot be mapped to a primitive type");
    }

    public JavaType deferedType(AbstractTypedTree tree) {
        return new DeferredType(tree);
    }

    public JavaType deferedType(JavaType uninferedType) {
        return new DeferredType(uninferedType);
    }

    static {
        unknownSymbol = new JavaSymbol.TypeJavaSymbol(1, "!unknownSymbol!", rootPackage){

            @Override
            public void addUsage(IdentifierTree tree) {
            }

            @Override
            public boolean isTypeSymbol() {
                return false;
            }

            @Override
            public boolean isUnknown() {
                return true;
            }
        };
        Symbols.unknownSymbol.members = new Scope(unknownSymbol){

            @Override
            public void enter(JavaSymbol symbol) {
            }
        };
        unknownType = new UnknownType(unknownSymbol);
        Symbols.unknownSymbol.type = unknownType;
        unknownMethodSymbol = new JavaSymbol.MethodJavaSymbol(0, "!unknown!", unknownSymbol){

            @Override
            public boolean isMethodSymbol() {
                return false;
            }

            @Override
            public JavaSymbol.TypeJavaSymbol getReturnType() {
                return unknownSymbol;
            }

            @Override
            public Symbol.TypeSymbol returnType() {
                return unknownSymbol;
            }

            @Override
            public boolean isUnknown() {
                return true;
            }
        };
    }
}

