/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.ProgramState;

public class ExplodedGraph {
    private Map<Node, Node> nodes = Maps.newHashMap();

    Node getNode(ProgramPoint programPoint, @Nullable ProgramState programState) {
        Node result = new Node(programPoint, programState);
        Node cached = this.nodes.get(result);
        if (cached != null) {
            cached.isNew = false;
            return cached;
        }
        result.isNew = true;
        this.nodes.put(result, result);
        return result;
    }

    public static class Node {
        boolean isNew;
        boolean exitPath = false;
        final ProgramPoint programPoint;
        @Nullable
        final ProgramState programState;

        Node(ProgramPoint programPoint, @Nullable ProgramState programState) {
            this.programPoint = programPoint;
            this.programState = programState;
        }

        public int hashCode() {
            return this.programPoint.hashCode() * 31 + (this.programState == null ? 0 : this.programState.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node other = (Node)obj;
                return this.programPoint.equals(other.programPoint) && Objects.equals(this.programState, other.programState);
            }
            return false;
        }

        public String toString() {
            return "B" + this.programPoint.block.id() + "." + this.programPoint.i + ": " + this.programState;
        }
    }

    public static class ProgramPoint {
        private int hashcode;
        final CFG.Block block;
        final int i;

        public ProgramPoint(CFG.Block block, int i) {
            this.block = block;
            this.i = i;
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                this.hashcode = this.block.id() * 31 + this.i;
            }
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProgramPoint) {
                ProgramPoint other = (ProgramPoint)obj;
                return this.block.id() == other.block.id() && this.i == other.i;
            }
            return false;
        }
    }
}

