/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.VariableTree;

public class ProgramState {
    private int hashCode;
    private final int constraintSize;
    public static final ProgramState EMPTY_STATE = new ProgramState(PCollections.emptyMap(), PCollections.emptyMap(), PCollections.emptyMap().put(SymbolicValue.NULL_LITERAL, ObjectConstraint.nullConstraint()).put(SymbolicValue.TRUE_LITERAL, (ObjectConstraint)((Object)BooleanConstraint.TRUE)).put(SymbolicValue.FALSE_LITERAL, (ObjectConstraint)((Object)BooleanConstraint.FALSE)), PCollections.emptyMap(), Lists.newLinkedList());
    private final PMap<ExplodedGraph.ProgramPoint, Integer> visitedPoints;
    private final Deque<SymbolicValue> stack;
    private final PMap<Symbol, SymbolicValue> values;
    private final PMap<SymbolicValue, Integer> references;
    private final PMap<SymbolicValue, Constraint> constraints;

    private ProgramState(PMap<Symbol, SymbolicValue> values, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, Constraint> constraints, PMap<ExplodedGraph.ProgramPoint, Integer> visitedPoints, Deque<SymbolicValue> stack) {
        this.values = values;
        this.references = references;
        this.constraints = constraints;
        this.visitedPoints = visitedPoints;
        this.stack = stack;
        this.constraintSize = 3;
    }

    private ProgramState(ProgramState ps, Deque<SymbolicValue> newStack) {
        this.values = ps.values;
        this.references = ps.references;
        this.constraints = ps.constraints;
        this.constraintSize = ps.constraintSize;
        this.visitedPoints = ps.visitedPoints;
        this.stack = newStack;
    }

    private ProgramState(ProgramState ps, PMap<SymbolicValue, Constraint> newConstraints) {
        this.values = ps.values;
        this.references = ps.references;
        this.constraints = newConstraints;
        this.constraintSize = ps.constraintSize + 1;
        this.visitedPoints = ps.visitedPoints;
        this.stack = ps.stack;
    }

    ProgramState stackValue(SymbolicValue sv) {
        LinkedList<SymbolicValue> newStack = new LinkedList<SymbolicValue>(this.stack);
        newStack.push(sv);
        return new ProgramState(this, newStack);
    }

    ProgramState clearStack() {
        return this.unstackValue((int)this.stack.size()).state;
    }

    public Pop unstackValue(int nbElements) {
        if (nbElements == 0) {
            return new Pop(this, Collections.emptyList());
        }
        Preconditions.checkArgument((this.stack.size() >= nbElements ? 1 : 0) != 0, (Object)nbElements);
        LinkedList<SymbolicValue> newStack = new LinkedList<SymbolicValue>(this.stack);
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < nbElements; ++i) {
            result.add(newStack.pop());
        }
        return new Pop(new ProgramState(this, newStack), result);
    }

    public SymbolicValue peekValue() {
        return this.stack.peek();
    }

    public List<SymbolicValue> peekValues(int n) {
        if (n > this.stack.size()) {
            throw new IllegalStateException("At least " + n + " values were expected on the stack!");
        }
        return ImmutableList.copyOf(this.stack).subList(0, n);
    }

    int numberOfTimeVisited(ExplodedGraph.ProgramPoint programPoint) {
        Integer count = this.visitedPoints.get(programPoint);
        return count == null ? 0 : count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramState that = (ProgramState)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.peekValue(), that.peekValue());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.values, this.constraints, this.peekValue());
        }
        return this.hashCode;
    }

    public String toString() {
        return "{" + this.values.toString() + "}  {" + this.constraints.toString() + "} { " + this.stack.toString() + " }";
    }

    public ProgramState addConstraint(SymbolicValue symbolicValue, Constraint constraint) {
        PMap<SymbolicValue, Constraint> newConstraints = this.constraints.put(symbolicValue, constraint);
        if (newConstraints != this.constraints) {
            return new ProgramState(this, newConstraints);
        }
        return this;
    }

    ProgramState put(Symbol symbol, SymbolicValue value) {
        if (symbol.isUnknown() || ProgramState.isVolatileField(symbol)) {
            return this;
        }
        SymbolicValue oldValue = this.values.get(symbol);
        if (oldValue == null || oldValue != value) {
            PMap<SymbolicValue, Integer> newReferences = this.references;
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            newReferences = ProgramState.increaseReference(newReferences, value);
            PMap<Symbol, SymbolicValue> newValues = this.values.put(symbol, value);
            return new ProgramState(newValues, newReferences, this.constraints, this.visitedPoints, this.stack);
        }
        return this;
    }

    private static boolean isVolatileField(Symbol symbol) {
        return ProgramState.isField(symbol) && symbol.isVolatile();
    }

    private static PMap<SymbolicValue, Integer> decreaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        Preconditions.checkNotNull((Object)value);
        return givenReferences.put(sv, value - 1);
    }

    private static PMap<SymbolicValue, Integer> increaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        if (value == null) {
            return givenReferences.put(sv, 1);
        }
        return givenReferences.put(sv, value + 1);
    }

    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable Object constraint) {
        return SymbolicValue.isDisposable(symbolicValue) && (constraint == null || !(constraint instanceof ObjectConstraint) || ((ObjectConstraint)constraint).isDisposable());
    }

    private static boolean inStack(Deque<SymbolicValue> stack, SymbolicValue symbolicValue) {
        for (SymbolicValue value : stack) {
            if (!value.equals(symbolicValue) && !value.references(symbolicValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLocalVariable(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isMethodSymbol();
    }

    public ProgramState cleanupDeadSymbols(final Set<Symbol> liveVariables) {
        class CleanAction
        implements BiConsumer<Symbol, SymbolicValue> {
            boolean newProgramState = false;
            PMap<Symbol, SymbolicValue> newValues = ProgramState.access$000(ProgramState.this);
            PMap<SymbolicValue, Integer> newReferences = ProgramState.access$100(ProgramState.this);
            PMap<SymbolicValue, Constraint> newConstraints = ProgramState.access$200(ProgramState.this);

            CleanAction() {
            }

            @Override
            public void accept(Symbol symbol, SymbolicValue symbolicValue) {
                if (ProgramState.isLocalVariable(symbol) && !liveVariables.contains(symbol)) {
                    this.newProgramState = true;
                    this.newValues = this.newValues.remove(symbol);
                    this.newReferences = ProgramState.decreaseReference(this.newReferences, symbolicValue);
                    if (!ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, this.newConstraints.get(symbolicValue)) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                        this.newConstraints = this.newConstraints.remove(symbolicValue);
                        this.newReferences = this.newReferences.remove(symbolicValue);
                    }
                }
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.values.forEach(cleanAction);
        return cleanAction.newProgramState ? new ProgramState(cleanAction.newValues, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack) : this;
    }

    public ProgramState cleanupConstraints() {
        class CleanAction
        implements BiConsumer<SymbolicValue, Constraint> {
            boolean newProgramState = false;
            PMap<SymbolicValue, Constraint> newConstraints = ProgramState.access$200(ProgramState.this);
            PMap<SymbolicValue, Integer> newReferences = ProgramState.access$100(ProgramState.this);

            CleanAction() {
            }

            @Override
            public void accept(SymbolicValue symbolicValue, Constraint constraint) {
                if (!ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, constraint) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                    this.newProgramState = true;
                    this.newConstraints = this.newConstraints.remove(symbolicValue);
                    this.newReferences = this.newReferences.remove(symbolicValue);
                }
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.constraints.forEach(cleanAction);
        return cleanAction.newProgramState ? new ProgramState(this.values, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack) : this;
    }

    public ProgramState resetFieldValues(ConstraintManager constraintManager) {
        ArrayList variableTrees = new ArrayList();
        this.values.forEach((symbol, symbolicValue) -> {
            VariableTree variable;
            if (ProgramState.isField(symbol) && (variable = ((Symbol.VariableSymbol)symbol).declaration()) != null) {
                variableTrees.add(variable);
            }
        });
        if (variableTrees.isEmpty()) {
            return this;
        }
        PMap<Symbol, SymbolicValue> newValues = this.values;
        PMap<SymbolicValue, Integer> newReferences = this.references;
        for (VariableTree variableTree : variableTrees) {
            Symbol symbol2 = variableTree.symbol();
            SymbolicValue oldValue = newValues.get(symbol2);
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            SymbolicValue newValue = constraintManager.createSymbolicValue(variableTree);
            newValues = newValues.put(symbol2, newValue);
            newReferences = ProgramState.increaseReference(newReferences, newValue);
        }
        return new ProgramState(newValues, newReferences, this.constraints, this.visitedPoints, this.stack);
    }

    public static boolean isField(Symbol symbol) {
        return symbol.isVariableSymbol() && !symbol.owner().isMethodSymbol();
    }

    private static boolean isReachable(SymbolicValue symbolicValue, PMap<SymbolicValue, Integer> references) {
        Integer integer = references.get(symbolicValue);
        return integer != null && integer > 0;
    }

    public boolean canReach(SymbolicValue symbolicValue) {
        return ProgramState.isReachable(symbolicValue, this.references);
    }

    public ProgramState visitedPoint(ExplodedGraph.ProgramPoint programPoint, int nbOfVisit) {
        return new ProgramState(this.values, this.references, this.constraints, this.visitedPoints.put(programPoint, nbOfVisit), this.stack);
    }

    @CheckForNull
    public Constraint getConstraint(SymbolicValue sv) {
        return this.constraints.get(sv);
    }

    public int constraintsSize() {
        return this.constraintSize;
    }

    @CheckForNull
    public SymbolicValue getValue(Symbol symbol) {
        return this.values.get(symbol);
    }

    public Map<SymbolicValue, ObjectConstraint> getValuesWithConstraints(Object state) {
        HashMap<SymbolicValue, ObjectConstraint> result = new HashMap<SymbolicValue, ObjectConstraint>();
        this.constraints.forEach((symbolicValue, valueConstraint) -> {
            ObjectConstraint constraint;
            if (valueConstraint instanceof ObjectConstraint && (constraint = (ObjectConstraint)valueConstraint).hasStatus(state)) {
                result.put((SymbolicValue)symbolicValue, constraint);
            }
        });
        return result;
    }

    public List<ObjectConstraint> getFieldConstraints(Object state) {
        Set<SymbolicValue> valuesAssignedToFields = this.getFieldValues();
        ArrayList<ObjectConstraint> result = new ArrayList<ObjectConstraint>();
        this.constraints.forEach((symbolicValue, valueConstraint) -> {
            ObjectConstraint constraint;
            if (valueConstraint instanceof ObjectConstraint && !valuesAssignedToFields.contains(symbolicValue) && (constraint = (ObjectConstraint)valueConstraint).hasStatus(state)) {
                result.add(constraint);
            }
        });
        return result;
    }

    public Set<SymbolicValue> getFieldValues() {
        HashSet<SymbolicValue> fieldValues = new HashSet<SymbolicValue>();
        this.values.forEach((symbol, symbolicValue) -> {
            if (ProgramState.isField(symbol)) {
                fieldValues.add((SymbolicValue)symbolicValue);
            }
        });
        return fieldValues;
    }

    public List<BinaryRelation> getKnownRelations() {
        ArrayList<BinaryRelation> knownRelations = new ArrayList<BinaryRelation>();
        this.constraints.forEach((symbolicValue, constraint) -> {
            BinaryRelation relation = symbolicValue.binaryRelation();
            if (relation != null) {
                if (BooleanConstraint.TRUE.equals(constraint)) {
                    knownRelations.add(relation);
                } else if (BooleanConstraint.FALSE.equals(constraint)) {
                    knownRelations.add(relation.inverse());
                }
            }
        });
        return knownRelations;
    }

    @CheckForNull
    public ObjectConstraint getConstraintWithStatus(SymbolicValue value, Object aState) {
        ObjectConstraint oConstraint;
        Constraint constraint = this.getConstraint(value.wrappedValue());
        if (constraint instanceof ObjectConstraint && (oConstraint = (ObjectConstraint)constraint).hasStatus(aState)) {
            return oConstraint;
        }
        return null;
    }

    static /* synthetic */ PMap access$000(ProgramState x0) {
        return x0.values;
    }

    static /* synthetic */ PMap access$100(ProgramState x0) {
        return x0.references;
    }

    static /* synthetic */ PMap access$200(ProgramState x0) {
        return x0.constraints;
    }

    public static class Pop {
        public final ProgramState state;
        public final List<SymbolicValue> values;

        public Pop(ProgramState programState, List<SymbolicValue> result) {
            this.state = programState;
            this.values = result;
        }
    }
}

