/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2583")
public class ConditionAlwaysTrueOrFalseCheck
extends SECheck {
    private final Set<Tree> evaluatedToFalse = Sets.newHashSet();
    private final Set<Tree> evaluatedToTrue = Sets.newHashSet();

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.evaluatedToFalse.clear();
        this.evaluatedToTrue.clear();
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        for (Tree condition : Sets.difference(this.evaluatedToFalse, this.evaluatedToTrue)) {
            context.reportIssue(condition, this, "Change this condition so that it does not always evaluate to \"false\"");
        }
        for (Tree condition : Sets.difference(this.evaluatedToTrue, this.evaluatedToFalse)) {
            context.reportIssue(condition, this, "Change this condition so that it does not always evaluate to \"true\"");
        }
    }

    public void evaluatedToFalse(Tree condition) {
        this.evaluatedToFalse.add(condition);
    }

    public void evaluatedToTrue(Tree condition) {
        this.evaluatedToTrue.add(condition);
    }
}

