/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.GreaterThanRelation;
import org.sonar.java.se.symbolicvalues.LessThanOrEqualRelation;
import org.sonar.java.se.symbolicvalues.LessThanRelation;
import org.sonar.java.se.symbolicvalues.MethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.NotEqualRelation;
import org.sonar.java.se.symbolicvalues.NotMethodEqualsRelation;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class EqualRelation
extends BinaryRelation {
    EqualRelation(SymbolicValue v1, SymbolicValue v2) {
        super(RelationalSymbolicValue.Kind.EQUAL, v1, v2);
    }

    @Override
    protected RelationState isImpliedBy(BinaryRelation relation) {
        return relation.impliesEqual();
    }

    @Override
    protected RelationState impliesEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesNotEqual() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesMethodEquals() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesNotMethodEquals() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesGreaterThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    protected RelationState impliesLessThan() {
        return RelationState.UNFULFILLED;
    }

    @Override
    protected RelationState impliesLessThanOrEqual() {
        return RelationState.FULFILLED;
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedAfter(BinaryRelation relation) {
        return relation.combinedWithEqual(this);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithEqual(EqualRelation relation) {
        return EqualRelation.binaryRelation(RelationalSymbolicValue.Kind.EQUAL, this.leftOp, relation.rightOp);
    }

    @Override
    @CheckForNull
    protected BinaryRelation combinedWithNotEqual(NotEqualRelation relation) {
        return EqualRelation.binaryRelation(RelationalSymbolicValue.Kind.NOT_EQUAL, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithMethodEquals(MethodEqualsRelation relation) {
        return EqualRelation.binaryRelation(RelationalSymbolicValue.Kind.METHOD_EQUALS, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithNotMethodEquals(NotMethodEqualsRelation relation) {
        return EqualRelation.binaryRelation(RelationalSymbolicValue.Kind.NOT_METHOD_EQUALS, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithGreaterThan(GreaterThanRelation relation) {
        return EqualRelation.binaryRelation(RelationalSymbolicValue.Kind.GREATER_THAN, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithGreaterThanOrEqual(GreaterThanOrEqualRelation relation) {
        return EqualRelation.binaryRelation(RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithLessThan(LessThanRelation relation) {
        return EqualRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN, this.leftOp, relation.rightOp);
    }

    @Override
    protected BinaryRelation combinedWithLessThanOrEqual(LessThanOrEqualRelation relation) {
        return EqualRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN_OR_EQUAL, this.leftOp, relation.rightOp);
    }
}

