/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.signature;

import org.sonar.java.signature.JvmJavaType;

public class Parameter {
    private final JvmJavaType jvmJavaType;
    private final String className;
    private final boolean isArray;

    public Parameter(JvmJavaType jvmJavaType, boolean isArray) {
        if (jvmJavaType == JvmJavaType.L) {
            throw new IllegalArgumentException();
        }
        this.jvmJavaType = jvmJavaType;
        this.className = null;
        this.isArray = isArray;
    }

    public Parameter(String classCanonicalName, boolean isArray) {
        if (classCanonicalName == null || "".equals(classCanonicalName)) {
            throw new IllegalArgumentException("With an Object JavaType, this is mandatory to specify the canonical name of the class.");
        }
        this.jvmJavaType = JvmJavaType.L;
        this.className = Parameter.extractClassName(classCanonicalName);
        this.isArray = isArray;
    }

    public Parameter(Parameter other) {
        this.jvmJavaType = other.jvmJavaType;
        this.className = other.className;
        this.isArray = other.isArray;
    }

    public boolean isVoid() {
        return this.jvmJavaType == JvmJavaType.V;
    }

    public JvmJavaType getJvmJavaType() {
        return this.jvmJavaType;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isOject() {
        return this.jvmJavaType == JvmJavaType.L;
    }

    private static String extractClassName(String classCanonicalName) {
        int slashIndex = classCanonicalName.lastIndexOf(47);
        int dollarIndex = classCanonicalName.lastIndexOf(36);
        if (slashIndex != -1 || dollarIndex != -1) {
            return classCanonicalName.substring(Math.max(slashIndex, dollarIndex) + 1);
        }
        return classCanonicalName;
    }
}

