/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.bytecode.loader.SquidClassLoader;

public final class ClassLoaderBuilder {
    private static final Logger LOG = Loggers.get(ClassLoaderBuilder.class);

    private ClassLoaderBuilder() {
    }

    public static ClassLoader create(Collection<File> bytecodeFilesOrDirectories) {
        ArrayList files = Lists.newArrayList();
        for (File file : bytecodeFilesOrDirectories) {
            if (file.isFile() && file.getPath().endsWith(".class")) {
                LOG.info("SonarQube Squid ClassLoader was expecting a JAR file instead of CLASS file : '" + file.getAbsolutePath() + "'");
                continue;
            }
            files.add(file);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("----- Classpath analyzed by Squid:");
            for (File file : files) {
                LOG.debug(file.getAbsolutePath());
            }
            LOG.debug("-----");
        }
        try {
            return new SquidClassLoader(files);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create ClassLoader", e);
        }
    }

    public static ClassLoader create(File bytecodeFileOrDirectory) {
        return ClassLoaderBuilder.create(Arrays.asList(bytecodeFileOrDirectory));
    }
}

