/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.model.statement.LabeledStatementTreeImpl;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;

public class LabelsVisitor
extends BaseTreeVisitor {
    private final Map<String, LabeledStatementTree> labelTrees;
    private final SemanticModel semanticModel;

    public LabelsVisitor(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
        this.labelTrees = Maps.newHashMap();
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        JavaSymbol.JavaLabelSymbol symbol = new JavaSymbol.JavaLabelSymbol(tree);
        ((LabeledStatementTreeImpl)tree).setSymbol(symbol);
        this.semanticModel.associateSymbol(tree, symbol);
        this.labelTrees.put(tree.label().name(), tree);
        super.visitLabeledStatement(tree);
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.associateLabel(tree.label());
        super.visitBreakStatement(tree);
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.associateLabel(tree.label());
        super.visitContinueStatement(tree);
    }

    private void associateLabel(@Nullable IdentifierTree label) {
        if (label == null) {
            return;
        }
        LabeledStatementTree labelTree = this.labelTrees.get(label.name());
        if (labelTree != null) {
            JavaSymbol symbol = (JavaSymbol)((Object)labelTree.symbol());
            ((IdentifierTreeImpl)label).setSymbol(symbol);
            symbol.addUsage(label);
        }
    }
}

