/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.LeastUpperBound;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeInferenceSolver;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Type;

public class TypeSubstitutionSolver {
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Symbols symbols;
    private final LeastUpperBound leastUpperBound;
    private final TypeInferenceSolver typeInferenceSolver;
    private Deque<JavaSymbol.TypeVariableJavaSymbol> typevarExplored = new LinkedList<JavaSymbol.TypeVariableJavaSymbol>();

    public TypeSubstitutionSolver(ParametrizedTypeCache parametrizedTypeCache, Symbols symbols) {
        this.parametrizedTypeCache = parametrizedTypeCache;
        this.symbols = symbols;
        this.leastUpperBound = new LeastUpperBound(this, parametrizedTypeCache, symbols);
        this.typeInferenceSolver = new TypeInferenceSolver(this.leastUpperBound, symbols, this);
    }

    Type leastUpperBound(Set<Type> refTypes) {
        return this.leastUpperBound.leastUpperBound(refTypes);
    }

    @CheckForNull
    TypeSubstitution getTypeSubstitution(JavaSymbol.MethodJavaSymbol method, JavaType site, List<JavaType> typeParams, List<JavaType> argTypes) {
        List<JavaType> formals = ((MethodJavaType)method.type).argTypes;
        TypeSubstitution substitution = new TypeSubstitution();
        if (method.isParametrized() || TypeSubstitutionSolver.constructParametrizedTypeWithoutSubstitution(method, site)) {
            if (!typeParams.isEmpty()) {
                substitution = this.getSubstitutionFromTypeParams(method.typeVariableTypes, typeParams);
            } else {
                if (formals.isEmpty()) {
                    return substitution;
                }
                formals = this.applySiteSubstitutionToFormalParameters(formals, site);
                substitution = this.typeInferenceSolver.inferTypeSubstitution(method, formals, argTypes);
            }
            if (!this.isValidSubtitution(substitution, site)) {
                return null;
            }
        }
        return substitution;
    }

    private static boolean constructParametrizedTypeWithoutSubstitution(JavaSymbol.MethodJavaSymbol method, JavaType site) {
        return method.isConstructor() && site.isParameterized() && ((ParametrizedTypeJavaType)site).typeSubstitution.isIdentity();
    }

    JavaType getReturnType(@Nullable JavaType returnType, JavaType defSite, JavaType callSite, TypeSubstitution substitution, JavaSymbol.MethodJavaSymbol method) {
        JavaType resultType = returnType;
        if (method.isConstructor()) {
            if (TypeSubstitutionSolver.constructParametrizedTypeWithoutSubstitution(method, defSite)) {
                resultType = this.applySubstitution(defSite, substitution);
            } else {
                return defSite;
            }
        }
        if (defSite == this.symbols.objectType && "getClass".equals(method.name())) {
            JavaSymbol.TypeJavaSymbol classSymbol = this.symbols.classType.symbol;
            JavaType wildcardType = this.parametrizedTypeCache.getWildcardType(callSite.erasure(), WildCardType.BoundType.EXTENDS);
            resultType = this.parametrizedTypeCache.getParametrizedTypeType(classSymbol, new TypeSubstitution().add(classSymbol.typeVariableTypes.get(0), wildcardType));
        }
        resultType = this.applySiteSubstitution(resultType, defSite);
        if (callSite != defSite) {
            resultType = this.applySiteSubstitution(resultType, callSite);
        }
        if (!TypeSubstitutionSolver.isReturnTypeCompletelySubstituted(resultType = this.applySubstitution(resultType, substitution), method.typeVariableTypes) || method.isConstructor() && !TypeSubstitutionSolver.isReturnTypeCompletelySubstituted(resultType, defSite.symbol.typeVariableTypes)) {
            resultType = this.symbols.deferedType(resultType);
        }
        return resultType;
    }

    private static boolean isReturnTypeCompletelySubstituted(JavaType resultType, List<TypeVariableJavaType> typeVariables) {
        if (typeVariables.contains(resultType)) {
            return false;
        }
        if (resultType.isArray()) {
            return TypeSubstitutionSolver.isReturnTypeCompletelySubstituted(((ArrayJavaType)resultType).elementType, typeVariables);
        }
        if (resultType.isTagged(16)) {
            return TypeSubstitutionSolver.isReturnTypeCompletelySubstituted(((WildCardType)resultType).bound, typeVariables);
        }
        if (resultType.isParameterized()) {
            for (JavaType substitutedType : ((ParametrizedTypeJavaType)resultType).typeSubstitution.substitutedTypes()) {
                if (TypeSubstitutionSolver.isReturnTypeCompletelySubstituted(substitutedType, typeVariables)) continue;
                return false;
            }
        }
        return true;
    }

    List<JavaType> applySiteSubstitutionToFormalParameters(List<JavaType> formals, JavaType site) {
        TypeSubstitution typeSubstitution = new TypeSubstitution();
        if (site.isParameterized()) {
            typeSubstitution = ((ParametrizedTypeJavaType)site).typeSubstitution;
        }
        JavaSymbol.TypeJavaSymbol siteSymbol = site.getSymbol();
        List<JavaType> newFormals = formals;
        Type superClass = siteSymbol.superClass();
        if (superClass != null) {
            JavaType newSuperClass = this.applySubstitution((JavaType)superClass, typeSubstitution);
            newFormals = this.applySiteSubstitutionToFormalParameters(newFormals, newSuperClass);
        }
        for (Type interfaceType : siteSymbol.interfaces()) {
            JavaType newInterfaceType = this.applySubstitution((JavaType)interfaceType, typeSubstitution);
            newFormals = this.applySiteSubstitutionToFormalParameters(newFormals, newInterfaceType);
        }
        return this.applySubstitutionToFormalParameters(newFormals, typeSubstitution);
    }

    JavaType applySiteSubstitution(JavaType type, JavaType site) {
        if (site.isParameterized()) {
            return this.applySubstitution(type, ((ParametrizedTypeJavaType)site).typeSubstitution);
        }
        return type;
    }

    JavaType applySiteSubstitution(@Nullable JavaType resolvedType, JavaType callSite, JavaType resolvedTypeDefinition) {
        if (resolvedType == null) {
            return null;
        }
        if (resolvedType.isTagged(12)) {
            MethodJavaType methodType = (MethodJavaType)resolvedType;
            JavaType resultType = this.applySiteSubstitution(methodType.resultType, callSite, resolvedTypeDefinition);
            List<JavaType> argTypes = methodType.argTypes.stream().map(argType -> this.applySiteSubstitution((JavaType)argType, callSite, resolvedTypeDefinition)).collect(Collectors.toList());
            return new MethodJavaType(argTypes, resultType, methodType.thrown, methodType.symbol);
        }
        return this.applySiteSubstitution(this.applySiteSubstitution(resolvedType, resolvedTypeDefinition), callSite);
    }

    List<JavaType> applySubstitutionToFormalParameters(List<JavaType> types, TypeSubstitution substitution) {
        if (substitution.size() == 0 || types.isEmpty()) {
            return types;
        }
        return types.stream().map(type -> this.applySubstitution((JavaType)type, substitution)).collect(Collectors.toList());
    }

    JavaType applySubstitution(JavaType type, TypeSubstitution substitution) {
        JavaType substitutedType = substitution.substitutedType(type);
        if (substitutedType != null) {
            return substitutedType;
        }
        if (type.isTagged(15)) {
            return this.substituteInTypeVar((TypeVariableJavaType)type, substitution);
        }
        if (type.isParameterized()) {
            return this.substituteInParametrizedType((ParametrizedTypeJavaType)type, substitution);
        }
        if (type.isTagged(16)) {
            return this.substituteInWildCardType((WildCardType)type, substitution);
        }
        if (type.isArray()) {
            return this.substituteInArrayType((ArrayJavaType)type, substitution);
        }
        return type;
    }

    private JavaType substituteInParametrizedType(ParametrizedTypeJavaType type, TypeSubstitution substitution) {
        TypeSubstitution newSubstitution = new TypeSubstitution();
        for (Map.Entry<TypeVariableJavaType, JavaType> entry : type.typeSubstitution.substitutionEntries()) {
            newSubstitution.add(entry.getKey(), this.applySubstitution(entry.getValue(), substitution));
        }
        return this.parametrizedTypeCache.getParametrizedTypeType(type.rawType.getSymbol(), newSubstitution);
    }

    private JavaType substituteInTypeVar(TypeVariableJavaType typevar, TypeSubstitution substitution) {
        if (this.typevarExplored.contains(typevar.symbol)) {
            return typevar;
        }
        this.typevarExplored.push((JavaSymbol.TypeVariableJavaSymbol)typevar.symbol);
        List subtitutedBounds = typevar.bounds.stream().map(t -> this.applySubstitution((JavaType)t, substitution)).collect(Collectors.toList());
        this.typevarExplored.pop();
        if (subtitutedBounds.equals(typevar.bounds)) {
            return typevar;
        }
        TypeVariableJavaType typeVariableJavaType = new TypeVariableJavaType((JavaSymbol.TypeVariableJavaSymbol)typevar.symbol);
        typeVariableJavaType.bounds = subtitutedBounds;
        return typeVariableJavaType;
    }

    private JavaType substituteInWildCardType(WildCardType wildcard, TypeSubstitution substitution) {
        JavaType substitutedType = this.applySubstitution(wildcard.bound, substitution);
        if (substitutedType != wildcard.bound) {
            return this.parametrizedTypeCache.getWildcardType(substitutedType, wildcard.boundType);
        }
        return wildcard;
    }

    private JavaType substituteInArrayType(ArrayJavaType arrayType, TypeSubstitution substitution) {
        JavaType rootElementType = arrayType.elementType;
        int nbDimensions = 1;
        while (rootElementType.isArray()) {
            rootElementType = ((ArrayJavaType)rootElementType).elementType;
            ++nbDimensions;
        }
        JavaType substitutedType = this.applySubstitution(rootElementType, substitution);
        if (substitutedType != rootElementType) {
            for (int i = 0; i < nbDimensions; ++i) {
                substitutedType = new ArrayJavaType(substitutedType, this.symbols.arrayClass);
            }
            return substitutedType;
        }
        return arrayType;
    }

    TypeSubstitution getSubstitutionFromTypeParams(List<TypeVariableJavaType> typeVariableTypes, List<JavaType> typeParams) {
        TypeSubstitution substitution = new TypeSubstitution();
        if (typeVariableTypes.size() == typeParams.size()) {
            for (int i = 0; i < typeVariableTypes.size(); ++i) {
                TypeVariableJavaType typeVariableType = typeVariableTypes.get(i);
                JavaType typeParam = typeParams.get(i);
                substitution.add(typeVariableType, typeParam);
            }
        }
        return substitution;
    }

    private boolean isValidSubtitution(TypeSubstitution substitutions, JavaType site) {
        for (Map.Entry<TypeVariableJavaType, JavaType> substitution : substitutions.substitutionEntries()) {
            if (this.isValidSubstitution(substitutions, substitution.getKey(), substitution.getValue(), site)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidSubstitution(TypeSubstitution candidate, TypeVariableJavaType typeVar, JavaType typeParam, JavaType site) {
        for (JavaType bound : typeVar.bounds) {
            JavaType currentBound = this.applySubstitution(bound, candidate);
            while (currentBound.isTagged(15) && !currentBound.symbol().owner().isMethodSymbol()) {
                JavaType newBound = candidate.substitutedType(currentBound);
                if (newBound == null && site.isParameterized()) {
                    newBound = ((ParametrizedTypeJavaType)site).typeSubstitution.substitutedType(currentBound);
                }
                if (newBound == null) {
                    return ((JavaSymbol.TypeJavaSymbol)site.symbol()).typeVariableTypes.contains(currentBound);
                }
                if (currentBound.equals(newBound)) break;
                currentBound = newBound;
            }
            if (TypeSubstitutionSolver.isUnboundedWildcard(typeParam) || typeParam.isSubtypeOf(currentBound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUnboundedWildcard(JavaType type) {
        return type.isTagged(16) && ((WildCardType)type).boundType == WildCardType.BoundType.UNBOUNDED;
    }

    JavaType erasureSubstitution(ParametrizedTypeJavaType type) {
        TypeSubstitution substitution = new TypeSubstitution();
        for (Map.Entry<TypeVariableJavaType, JavaType> entry : type.typeSubstitution.substitutionEntries()) {
            JavaType subs;
            TypeVariableJavaType typeVar = entry.getKey();
            if (typeVar == (subs = entry.getValue())) {
                subs = subs.erasure();
            }
            substitution.add(typeVar, subs);
        }
        return this.parametrizedTypeCache.getParametrizedTypeType(type.symbol, substitution);
    }

    static TypeSubstitution substitutionFromSuperType(ParametrizedTypeJavaType target, ParametrizedTypeJavaType source) {
        TypeSubstitution result = new TypeSubstitution(target.typeSubstitution);
        if (target.rawType != source.rawType) {
            JavaSymbol.TypeJavaSymbol targetSymbol = target.symbol;
            Type superClass = targetSymbol.superClass();
            if (superClass != null && ((JavaType)superClass).isParameterized()) {
                TypeSubstitution newSub = TypeSubstitutionSolver.substitutionFromSuperType((ParametrizedTypeJavaType)superClass, source);
                result = result.combine(newSub);
            }
            for (Type superInterface : targetSymbol.interfaces()) {
                if (!((JavaType)superInterface).isParameterized()) continue;
                TypeSubstitution newSub = TypeSubstitutionSolver.substitutionFromSuperType((ParametrizedTypeJavaType)superInterface, source);
                result = result.combine(newSub);
            }
        } else {
            result = target.typeSubstitution.combine(source.typeSubstitution);
        }
        return result;
    }
}

