/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Tree;

public class ExplodedGraph {
    private Map<Node, Node> nodes = Maps.newHashMap();

    Node getNode(ProgramPoint programPoint, @Nullable ProgramState programState) {
        Node result = new Node(programPoint, programState);
        Node cached = this.nodes.get(result);
        if (cached != null) {
            cached.isNew = false;
            return cached;
        }
        result.isNew = true;
        this.nodes.put(result, result);
        return result;
    }

    public Map<Node, Node> getNodes() {
        return this.nodes;
    }

    public static class Node {
        boolean isNew;
        boolean exitPath = false;
        boolean happyPath = true;
        public final ProgramPoint programPoint;
        @Nullable
        public final ProgramState programState;
        private final List<Node> parents;
        private final List<LearnedConstraint> learnedConstraints;
        private final List<LearnedValue> learnedSymbols;

        public Node(ProgramPoint programPoint, @Nullable ProgramState programState) {
            this.programPoint = programPoint;
            this.programState = programState;
            this.learnedConstraints = new ArrayList<LearnedConstraint>();
            this.learnedSymbols = new ArrayList<LearnedValue>();
            this.parents = new ArrayList<Node>();
        }

        public void setParent(@Nullable Node parent) {
            if (parent != null) {
                if (this.parents.isEmpty()) {
                    this.programState.constraints.forEach((sv, c) -> {
                        if (parent.programState.getConstraint((SymbolicValue)sv) != c) {
                            this.addConstraint((SymbolicValue)sv, (Constraint)c);
                        }
                    });
                    this.programState.values.forEach((s, sv) -> {
                        if (parent.programState.getValue((Symbol)s) != sv) {
                            this.learnedSymbols.add(new LearnedValue((SymbolicValue)sv, (Symbol)s));
                        }
                    });
                }
                this.parents.add(parent);
            }
        }

        private void addConstraint(SymbolicValue sv, @Nullable Constraint constraint) {
            if (sv instanceof BinarySymbolicValue) {
                BinarySymbolicValue binarySymbolicValue = (BinarySymbolicValue)sv;
                this.addConstraint(binarySymbolicValue.getLeftOp(), null);
                this.addConstraint(binarySymbolicValue.getRightOp(), null);
            }
            this.learnedConstraints.add(new LearnedConstraint(sv, constraint));
        }

        public void addParent(Node node) {
            this.parents.add(node);
        }

        @Nullable
        public Node parent() {
            return this.parents.isEmpty() ? null : this.parents.get(0);
        }

        public List<Node> getParents() {
            return this.parents;
        }

        public List<LearnedConstraint> getLearnedConstraints() {
            return this.learnedConstraints;
        }

        public List<LearnedValue> getLearnedSymbols() {
            return this.learnedSymbols;
        }

        public int hashCode() {
            return this.programPoint.hashCode() * 31 + (this.programState == null ? 0 : this.programState.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node other = (Node)obj;
                return this.programPoint.equals(other.programPoint) && Objects.equals(this.programState, other.programState);
            }
            return false;
        }

        public String toString() {
            return "B" + this.programPoint.block.id() + "." + this.programPoint.i + ": " + this.programState;
        }

        public static class LearnedValue {
            final SymbolicValue sv;
            final Symbol symbol;

            public LearnedValue(SymbolicValue sv, Symbol symbol) {
                this.sv = sv;
                this.symbol = symbol;
            }

            public Symbol getSymbol() {
                return this.symbol;
            }

            public SymbolicValue getSv() {
                return this.sv;
            }

            public String toString() {
                return this.sv + " - " + this.symbol.name();
            }
        }

        public static class LearnedConstraint {
            final SymbolicValue sv;
            @Nullable
            final Constraint constraint;

            public LearnedConstraint(SymbolicValue sv, @Nullable Constraint constraint) {
                this.sv = sv;
                this.constraint = constraint;
            }

            public SymbolicValue getSv() {
                return this.sv;
            }

            @CheckForNull
            public Constraint getConstraint() {
                return this.constraint;
            }

            public String toString() {
                return this.sv + " - " + this.constraint;
            }
        }
    }

    public static class ProgramPoint {
        private int hashcode;
        final CFG.Block block;
        final int i;

        public ProgramPoint(CFG.Block block, int i) {
            this.block = block;
            this.i = i;
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                this.hashcode = this.block.id() * 31 + this.i;
            }
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProgramPoint) {
                ProgramPoint other = (ProgramPoint)obj;
                return this.block.id() == other.block.id() && this.i == other.i;
            }
            return false;
        }

        public String toString() {
            String tree = "";
            if (this.i < this.block.elements().size()) {
                tree = "" + (Object)((Object)this.block.elements().get(this.i).kind()) + this.block.elements().get(this.i).firstToken().line();
            }
            return "B" + this.block.id() + "." + this.i + "  " + tree;
        }

        public Tree syntaxTree() {
            if (this.block.elements().isEmpty()) {
                return this.block.terminator();
            }
            return this.block.elements().get(Math.min(this.i, this.block.elements().size() - 1));
        }
    }
}

