/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.LiveVariables;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.SymbolMetadataResolve;
import org.sonar.java.resolve.Types;
import org.sonar.java.se.CheckerDispatcher;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.MethodBehavior;
import org.sonar.java.se.Pair;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.checks.ConditionAlwaysTrueOrFalseCheck;
import org.sonar.java.se.checks.DivisionByZeroCheck;
import org.sonar.java.se.checks.LocksNotUnlockedCheck;
import org.sonar.java.se.checks.NoWayOutLoopCheck;
import org.sonar.java.se.checks.NonNullSetToNullCheck;
import org.sonar.java.se.checks.NullDereferenceCheck;
import org.sonar.java.se.checks.OptionalGetBeforeIsPresentCheck;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.UnclosedResourcesCheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class ExplodedGraphWalker {
    private static final String EQUALS_METHOD_NAME = "equals";
    private static final int MAX_STEPS = 16000;
    public static final int MAX_NESTED_BOOLEAN_STATES = 10000;
    private static final Logger LOG = Loggers.get(ExplodedGraphWalker.class);
    private static final Set<String> THIS_SUPER = ImmutableSet.of((Object)"this", (Object)"super");
    private static final boolean DEBUG_MODE_ACTIVATED = false;
    @VisibleForTesting
    static final int MAX_EXEC_PROGRAM_POINT = 2;
    private static final MethodMatcher SYSTEM_EXIT_MATCHER = MethodMatcher.create().typeDefinition("java.lang.System").name("exit").addParameter("int");
    private static final MethodMatcher OBJECT_WAIT_MATCHER = MethodMatcher.create().typeDefinition("java.lang.Object").name("wait").withAnyParameters();
    private static final MethodMatcher THREAD_SLEEP_MATCHER = MethodMatcher.create().typeDefinition("java.lang.Thread").name("sleep").withAnyParameters();
    private final ConditionAlwaysTrueOrFalseCheck alwaysTrueOrFalseChecker;
    private MethodTree methodTree;
    private ExplodedGraph explodedGraph;
    @VisibleForTesting
    Deque<ExplodedGraph.Node> workList;
    ExplodedGraph.Node node;
    ExplodedGraph.ProgramPoint programPosition;
    ProgramState programState;
    private LiveVariables liveVariables;
    private CheckerDispatcher checkerDispatcher;
    private final SymbolicExecutionVisitor symbolicExecutionVisitor;
    @VisibleForTesting
    int steps;
    ConstraintManager constraintManager;
    private boolean cleanup = true;
    MethodBehavior methodBehavior;
    private Set<ExplodedGraph.Node> endOfExecutionPath;

    @VisibleForTesting
    public ExplodedGraphWalker() {
        this.alwaysTrueOrFalseChecker = new ConditionAlwaysTrueOrFalseCheck();
        ArrayList checks = Lists.newArrayList((Object[])new SECheck[]{this.alwaysTrueOrFalseChecker, new NullDereferenceCheck(), new DivisionByZeroCheck(), new UnclosedResourcesCheck(), new LocksNotUnlockedCheck(), new NonNullSetToNullCheck(), new NoWayOutLoopCheck()});
        this.checkerDispatcher = new CheckerDispatcher(this, checks);
        this.symbolicExecutionVisitor = new SymbolicExecutionVisitor(checks);
    }

    @VisibleForTesting
    ExplodedGraphWalker(boolean cleanup) {
        this();
        this.cleanup = cleanup;
    }

    private ExplodedGraphWalker(ConditionAlwaysTrueOrFalseCheck alwaysTrueOrFalseChecker, List<SECheck> seChecks, SymbolicExecutionVisitor symbolicExecutionVisitor) {
        this.alwaysTrueOrFalseChecker = alwaysTrueOrFalseChecker;
        this.checkerDispatcher = new CheckerDispatcher(this, seChecks);
        this.symbolicExecutionVisitor = symbolicExecutionVisitor;
    }

    public ExplodedGraph getExplodedGraph() {
        return this.explodedGraph;
    }

    public MethodBehavior visitMethod(MethodTree tree, MethodBehavior methodBehavior) {
        BlockTree body = tree.block();
        this.methodBehavior = methodBehavior;
        if (body != null) {
            this.execute(tree);
        }
        return this.methodBehavior;
    }

    private void execute(MethodTree tree) {
        CFG cfg = CFG.build(tree);
        this.checkerDispatcher.init(tree, cfg);
        this.liveVariables = LiveVariables.analyze(cfg);
        this.explodedGraph = new ExplodedGraph();
        this.methodTree = tree;
        this.constraintManager = new ConstraintManager();
        this.workList = new LinkedList<ExplodedGraph.Node>();
        this.endOfExecutionPath = new HashSet<ExplodedGraph.Node>();
        this.programState = ProgramState.EMPTY_STATE;
        this.steps = 0;
        for (ProgramState startingState : this.startingStates(tree, this.programState)) {
            this.enqueue(new ExplodedGraph.ProgramPoint(cfg.entry(), 0), startingState);
        }
        while (!this.workList.isEmpty()) {
            ++this.steps;
            if (this.steps > 16000) {
                this.throwMaxSteps(tree);
            }
            this.setNode(this.workList.removeFirst());
            if (this.programPosition.block.successors().isEmpty()) {
                this.endOfExecutionPath.add(this.node);
                continue;
            }
            try {
                if (this.programPosition.i < this.programPosition.block.elements().size()) {
                    this.visit(this.programPosition.block.elements().get(this.programPosition.i), this.programPosition.block.terminator());
                    continue;
                }
                if (this.programPosition.block.terminator() == null) {
                    this.handleBlockExit(this.programPosition);
                    continue;
                }
                if (this.programPosition.i == this.programPosition.block.elements().size()) {
                    this.checkerDispatcher.executeCheckPostStatement(this.programPosition.block.terminator());
                    continue;
                }
                this.checkerDispatcher.executeCheckPreStatement(this.programPosition.block.terminator());
                this.handleBlockExit(this.programPosition);
            }
            catch (TooManyNestedBooleanStatesException e) {
                this.throwTooManyBooleanStates(tree, e);
            }
        }
        this.handleEndOfExecutionPath();
        this.checkerDispatcher.executeCheckEndOfExecution();
        this.workList = null;
        this.node = null;
        this.programState = null;
        this.constraintManager = null;
    }

    private void throwTooManyBooleanStates(MethodTree tree, TooManyNestedBooleanStatesException e) {
        this.interrupted();
        String message = String.format("reached maximum number of %d branched states for method %s in class %s", 10000, tree.simpleName().name(), tree.symbol().owner().name());
        throw new MaximumStepsReachedException(message, e);
    }

    private void throwMaxSteps(MethodTree tree) {
        this.interrupted();
        String message = String.format("reached limit of %d steps for method %s#%d in class %s", 16000, tree.simpleName().name(), tree.simpleName().firstToken().line(), tree.symbol().owner().name());
        throw new MaximumStepsReachedException(message);
    }

    private void interrupted() {
        this.handleEndOfExecutionPath();
        this.checkerDispatcher.interruptedExecution();
    }

    private void setNode(ExplodedGraph.Node node) {
        this.node = node;
        this.programPosition = this.node.programPoint;
        this.programState = this.node.programState;
    }

    private void handleEndOfExecutionPath() {
        ExplodedGraph.Node savedNode = this.node;
        this.endOfExecutionPath.forEach(n -> {
            this.setNode((ExplodedGraph.Node)n);
            if (!this.programState.exitingOnRuntimeException()) {
                this.checkerDispatcher.executeCheckEndOfExecutionPath(this.constraintManager);
            }
            this.methodBehavior.createYield(this.programState, this.node.happyPath);
        });
        this.setNode(savedNode);
    }

    private Iterable<ProgramState> startingStates(MethodTree tree, ProgramState currentState) {
        Stream<ProgramState> stateStream = Stream.of(currentState);
        boolean isEqualsMethod = EQUALS_METHOD_NAME.equals(tree.simpleName().name()) && tree.parameters().size() == 1;
        SymbolMetadataResolve packageMetadata = ((JavaSymbol.MethodJavaSymbol)tree.symbol()).packge().metadata();
        boolean nonNullParams = packageMetadata.isAnnotatedWith("javax.annotation.ParametersAreNonnullByDefault");
        boolean nullableParams = packageMetadata.isAnnotatedWith("javax.annotation.ParametersAreNullableByDefault");
        for (VariableTree variableTree : tree.parameters()) {
            SymbolicValue sv = this.constraintManager.createSymbolicValue(variableTree);
            Symbol variableSymbol = variableTree.symbol();
            this.methodBehavior.addParameter(variableSymbol, sv);
            stateStream = stateStream.map(ps -> ps.put(variableSymbol, sv));
            if (isEqualsMethod || ExplodedGraphWalker.parameterCanBeNull(variableSymbol, nullableParams)) {
                stateStream = stateStream.flatMap(ps -> Stream.concat(sv.setConstraint((ProgramState)ps, ObjectConstraint.nullConstraint()).stream(), sv.setConstraint((ProgramState)ps, ObjectConstraint.notNull()).stream()));
                continue;
            }
            if (!nonNullParams) continue;
            stateStream = stateStream.flatMap(ps -> sv.setConstraint((ProgramState)ps, ObjectConstraint.notNull()).stream());
        }
        return stateStream.collect(Collectors.toList());
    }

    private static boolean parameterCanBeNull(Symbol variableSymbol, boolean nullableParams) {
        SymbolMetadata metadata = variableSymbol.metadata();
        return metadata.isAnnotatedWith("javax.annotation.CheckForNull") || metadata.isAnnotatedWith("javax.annotation.Nullable") || nullableParams && !variableSymbol.type().isPrimitive();
    }

    private void cleanUpProgramState(CFG.Block block) {
        if (this.cleanup) {
            this.programState = this.programState.cleanupDeadSymbols(this.liveVariables.getOut(block), this.methodBehavior.parameters());
            this.programState = this.programState.cleanupConstraints();
        }
    }

    private void handleBlockExit(ExplodedGraph.ProgramPoint programPosition) {
        CFG.Block block = programPosition.block;
        Tree terminator = block.terminator();
        this.cleanUpProgramState(block);
        boolean exitPath = this.node.exitPath;
        if (terminator != null) {
            switch (terminator.kind()) {
                case IF_STATEMENT: {
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(((IfStatementTree)terminator).condition()));
                    return;
                }
                case CONDITIONAL_OR: 
                case CONDITIONAL_AND: {
                    this.handleBranch(block, ((BinaryExpressionTree)terminator).leftOperand());
                    return;
                }
                case CONDITIONAL_EXPRESSION: {
                    this.handleBranch(block, ((ConditionalExpressionTree)terminator).condition());
                    return;
                }
                case FOR_STATEMENT: {
                    ExpressionTree condition = ((ForStatementTree)terminator).condition();
                    if (condition == null) break;
                    this.handleBranch(block, condition, false);
                    return;
                }
                case WHILE_STATEMENT: {
                    ExpressionTree whileCondition = ((WhileStatementTree)terminator).condition();
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(whileCondition), !whileCondition.is(Tree.Kind.BOOLEAN_LITERAL));
                    return;
                }
                case DO_STATEMENT: {
                    ExpressionTree doCondition = ((DoWhileStatementTree)terminator).condition();
                    this.handleBranch(block, ExplodedGraphWalker.cleanupCondition(doCondition), !doCondition.is(Tree.Kind.BOOLEAN_LITERAL));
                    return;
                }
                case SYNCHRONIZED_STATEMENT: {
                    this.resetFieldValues();
                    break;
                }
                case RETURN_STATEMENT: {
                    ExpressionTree returnExpression = ((ReturnStatementTree)terminator).expression();
                    if (returnExpression == null) break;
                    this.programState.storeExitValue();
                    break;
                }
                case THROW_STATEMENT: {
                    ProgramState.Pop unstack = this.programState.unstackValue(1);
                    this.programState = unstack.state.stackValue(this.constraintManager.createExceptionalSymbolicValue(((ThrowStatementTree)terminator).expression().symbolType()));
                    this.programState.storeExitValue();
                    break;
                }
            }
        }
        if (exitPath) {
            if (block.exitBlock() != null) {
                this.enqueue(new ExplodedGraph.ProgramPoint(block.exitBlock(), 0), this.programState, true);
            } else {
                for (CFG.Block successor : block.successors()) {
                    this.enqueue(new ExplodedGraph.ProgramPoint(successor, 0), this.programState, true);
                }
            }
        } else {
            for (CFG.Block successor : block.successors()) {
                if (block.isFinallyBlock() && !ExplodedGraphWalker.isDirectFlowSuccessorOf(successor, block)) continue;
                this.node.happyPath = terminator == null || !terminator.is(Tree.Kind.THROW_STATEMENT);
                this.enqueue(new ExplodedGraph.ProgramPoint(successor, 0), this.programState, successor == block.exitBlock());
            }
        }
    }

    private static boolean isDirectFlowSuccessorOf(CFG.Block successor, CFG.Block block) {
        return successor != block.exitBlock() || successor.isMethodExitBlock();
    }

    private static ExpressionTree cleanupCondition(ExpressionTree condition) {
        ExpressionTree cleanedUpCondition = ExpressionUtils.skipParentheses(condition);
        if (cleanedUpCondition.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            cleanedUpCondition = ExplodedGraphWalker.cleanupCondition(((BinaryExpressionTree)cleanedUpCondition).rightOperand());
        }
        return cleanedUpCondition;
    }

    private void handleBranch(CFG.Block programPosition, Tree condition) {
        this.handleBranch(programPosition, condition, true);
    }

    private void handleBranch(CFG.Block programPosition, Tree condition, boolean checkPath) {
        Pair<List<ProgramState>, List<ProgramState>> pair = this.constraintManager.assumeDual(this.programState);
        ExplodedGraph.ProgramPoint falseBlockProgramPoint = new ExplodedGraph.ProgramPoint(programPosition.falseBlock(), 0);
        Iterator iterator = ((List)pair.a).iterator();
        while (iterator.hasNext()) {
            ProgramState state;
            ProgramState ps = state = (ProgramState)iterator.next();
            if (condition.parent().is(Tree.Kind.CONDITIONAL_AND) && !ExplodedGraphWalker.isPartOfConditionalExpressionCondition(condition)) {
                ps = state.stackValue(SymbolicValue.FALSE_LITERAL);
            }
            this.enqueue(falseBlockProgramPoint, ps, this.node.exitPath);
            if (!checkPath) continue;
            this.alwaysTrueOrFalseChecker.evaluatedToFalse(condition, this.node);
        }
        ExplodedGraph.ProgramPoint trueBlockProgramPoint = new ExplodedGraph.ProgramPoint(programPosition.trueBlock(), 0);
        Iterator iterator2 = ((List)pair.b).iterator();
        while (iterator2.hasNext()) {
            ProgramState state;
            ProgramState ps = state = (ProgramState)iterator2.next();
            if (condition.parent().is(Tree.Kind.CONDITIONAL_OR) && !ExplodedGraphWalker.isPartOfConditionalExpressionCondition(condition)) {
                ps = state.stackValue(SymbolicValue.TRUE_LITERAL);
            }
            this.enqueue(trueBlockProgramPoint, ps, this.node.exitPath);
            if (!checkPath) continue;
            this.alwaysTrueOrFalseChecker.evaluatedToTrue(condition, this.node);
        }
    }

    private static boolean isPartOfConditionalExpressionCondition(Tree tree) {
        Tree current;
        Tree parent = tree;
        do {
            current = parent;
        } while ((parent = parent.parent()).is(Tree.Kind.PARENTHESIZED_EXPRESSION, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR));
        return parent.is(Tree.Kind.CONDITIONAL_EXPRESSION) && current.equals(((ConditionalExpressionTree)parent).condition());
    }

    private void visit(Tree tree, @Nullable Tree terminator) {
        if (!this.checkerDispatcher.executeCheckPreStatement(tree)) {
            return;
        }
        switch (tree.kind()) {
            case METHOD_INVOCATION: {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                if (SYSTEM_EXIT_MATCHER.matches(mit)) {
                    return;
                }
                this.executeMethodInvocation(mit);
                return;
            }
            case LABELED_STATEMENT: 
            case SWITCH_STATEMENT: 
            case EXPRESSION_STATEMENT: 
            case PARENTHESIZED_EXPRESSION: {
                throw new IllegalStateException("Cannot appear in CFG: " + tree.kind().name());
            }
            case VARIABLE: {
                this.executeVariable((VariableTree)tree, terminator);
                break;
            }
            case TYPE_CAST: {
                this.executeTypeCast((TypeCastTree)tree);
                break;
            }
            case ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                this.executeAssignement((AssignmentExpressionTree)tree);
                break;
            }
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                this.executeLogicalAssignment((AssignmentExpressionTree)tree);
                break;
            }
            case ARRAY_ACCESS_EXPRESSION: {
                this.executeArrayAccessExpression((ArrayAccessExpressionTree)tree);
                break;
            }
            case NEW_ARRAY: {
                this.executeNewArray((NewArrayTree)tree);
                break;
            }
            case NEW_CLASS: {
                this.executeNewClass((NewClassTree)tree);
                break;
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case AND: 
            case XOR: 
            case OR: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                this.executeBinaryExpression(tree);
                break;
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case INSTANCE_OF: {
                this.executeUnaryExpression(tree);
                break;
            }
            case IDENTIFIER: {
                this.executeIdentifier((IdentifierTree)tree);
                break;
            }
            case MEMBER_SELECT: {
                this.executeMemberSelect((MemberSelectExpressionTree)tree);
                break;
            }
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: {
                SymbolicValue val = this.constraintManager.createSymbolicValue(tree);
                this.programState = this.programState.stackValue(val);
                this.programState = this.programState.addConstraint(val, ObjectConstraint.notNull());
                break;
            }
            case BOOLEAN_LITERAL: {
                boolean value = Boolean.parseBoolean(((LiteralTree)tree).value());
                this.programState = this.programState.stackValue(value ? SymbolicValue.TRUE_LITERAL : SymbolicValue.FALSE_LITERAL);
                break;
            }
            case NULL_LITERAL: {
                this.programState = this.programState.stackValue(SymbolicValue.NULL_LITERAL);
                break;
            }
            case LAMBDA_EXPRESSION: 
            case METHOD_REFERENCE: {
                this.programState = this.programState.stackValue(this.constraintManager.createSymbolicValue(tree));
                break;
            }
        }
        this.checkerDispatcher.executeCheckPostStatement(tree);
        this.clearStack(tree);
    }

    private void executeMethodInvocation(MethodInvocationTree mit) {
        this.setSymbolicValueOnFields(mit);
        ProgramState.Pop unstack = this.programState.unstackValue(mit.arguments().size() + 1);
        this.logState(mit);
        this.programState = unstack.state;
        MethodBehavior methodInvokedBehavior = null;
        Symbol methodSymbol = mit.symbol();
        Tree declaration = methodSymbol.declaration();
        if (declaration != null) {
            methodInvokedBehavior = this.symbolicExecutionVisitor.execute((MethodTree)declaration);
        }
        this.enqueueUncheckedExceptionalPaths();
        SymbolicValue resultValue = this.constraintManager.createMethodSymbolicValue(mit, unstack.values);
        if (methodInvokedBehavior != null && methodInvokedBehavior.isComplete() && ExplodedGraphWalker.methodCanNotBeOverriden(methodSymbol)) {
            List<SymbolicValue> invocationArguments = ExplodedGraphWalker.invocationArguments(unstack.values);
            List invocationTypes = mit.arguments().stream().map(ExpressionTree::symbolType).collect(Collectors.toList());
            HashMap thrownExceptionsByExceptionType = new HashMap();
            methodInvokedBehavior.exceptionalPathYields().flatMap(yield -> yield.statesAfterInvocation(invocationArguments, invocationTypes, this.programState, () -> thrownExceptionsByExceptionType.computeIfAbsent(yield.exceptionType, this.constraintManager::createExceptionalSymbolicValue))).forEach(ps -> this.enqueueExceptionalPaths(ps.clearStack(), (SymbolicValue.ExceptionalSymbolicValue)ps.peekValue()));
            methodInvokedBehavior.happyPathYields().flatMap(yield -> yield.statesAfterInvocation(invocationArguments, invocationTypes, this.programState, () -> resultValue)).map(psYield -> this.handleSpecialMethods((ProgramState)psYield, mit)).forEach(psYield -> {
                this.checkerDispatcher.syntaxNode = mit;
                this.checkerDispatcher.addTransition((ProgramState)psYield);
                this.clearStack(mit);
            });
        } else {
            this.enqueueThrownExceptionalPaths(methodSymbol);
            this.programState = this.handleSpecialMethods(this.programState.stackValue(resultValue), mit);
            this.checkerDispatcher.executeCheckPostStatement(mit);
            this.clearStack(mit);
        }
    }

    private ProgramState handleSpecialMethods(ProgramState ps, MethodInvocationTree mit) {
        if (ExplodedGraphWalker.isNonNullMethod(mit.symbol())) {
            return ps.addConstraint(ps.peekValue(), ObjectConstraint.notNull());
        }
        if (OBJECT_WAIT_MATCHER.matches(mit)) {
            return ps.resetFieldValues(this.constraintManager);
        }
        return ps;
    }

    private void enqueueThrownExceptionalPaths(Symbol symbol) {
        if (!symbol.isMethodSymbol()) {
            return;
        }
        ProgramState ps = this.programState.clearStack();
        ((Symbol.MethodSymbol)symbol).thrownTypes().stream().map(this.constraintManager::createExceptionalSymbolicValue).forEach(exceptionSV -> this.enqueueExceptionalPaths(ps, (SymbolicValue.ExceptionalSymbolicValue)exceptionSV));
    }

    private void enqueueUncheckedExceptionalPaths() {
        this.enqueueExceptionalPaths(this.programState.clearStack(), this.constraintManager.createExceptionalSymbolicValue(null));
    }

    private void enqueueExceptionalPaths(ProgramState ps, SymbolicValue.ExceptionalSymbolicValue exceptionSV) {
        Set<CFG.Block> exceptionBlocks = this.node.programPoint.block.exceptions();
        List catchBlocks = exceptionBlocks.stream().filter(CFG.Block.IS_CATCH_BLOCK).collect(Collectors.toList());
        Optional<CFG.Block> firstMatchingCatchBlock = catchBlocks.stream().filter(b -> ExplodedGraphWalker.isCaughtByBlock(exceptionSV.exceptionType(), b)).sorted((b1, b2) -> Integer.compare(b2.id(), b1.id())).findFirst();
        if (firstMatchingCatchBlock.isPresent()) {
            this.enqueue(new ExplodedGraph.ProgramPoint(firstMatchingCatchBlock.get(), 0), ps);
            return;
        }
        catchBlocks.stream().filter(ExplodedGraphWalker::isCatchingUncheckedException).forEach(b -> this.enqueue(new ExplodedGraph.ProgramPoint((CFG.Block)b, 0), ps));
        ProgramState newPs = ps.clearStack().stackValue(exceptionSV);
        newPs.storeExitValue();
        exceptionBlocks.stream().filter(CFG.Block.IS_CATCH_BLOCK.negate()).forEach(b -> this.enqueue(new ExplodedGraph.ProgramPoint((CFG.Block)b, 0), newPs, true));
        this.node.programPoint.block.successors().stream().filter(CFG.Block::isMethodExitBlock).forEach(b -> this.enqueue(new ExplodedGraph.ProgramPoint((CFG.Block)b, 0), newPs, true));
    }

    private static boolean isCaughtByBlock(@Nullable Type thrownType, CFG.Block catchBlock) {
        if (thrownType != null) {
            Type caughtType = ((VariableTree)catchBlock.elements().get(0)).symbol().type();
            return thrownType.isSubtypeOf(caughtType);
        }
        return false;
    }

    private static boolean isCatchingUncheckedException(CFG.Block catchBlock) {
        Type caughtType = ((VariableTree)catchBlock.elements().get(0)).symbol().type();
        return caughtType.isSubtypeOf("java.lang.RuntimeException") || caughtType.isSubtypeOf("java.lang.Error") || caughtType.is("java.lang.Exception") || caughtType.is("java.lang.Throwable");
    }

    private static boolean methodCanNotBeOverriden(Symbol methodSymbol) {
        if ((((JavaSymbol.MethodJavaSymbol)methodSymbol).flags() & 0x100) != 0) {
            return false;
        }
        return !methodSymbol.isAbstract() && (methodSymbol.isPrivate() || methodSymbol.isFinal() || methodSymbol.isStatic() || methodSymbol.owner().isFinal());
    }

    private static List<SymbolicValue> invocationArguments(List<SymbolicValue> values) {
        ArrayList<SymbolicValue> parameterValues = new ArrayList<SymbolicValue>(values);
        parameterValues.remove(values.size() - 1);
        Collections.reverse(parameterValues);
        return parameterValues;
    }

    private static boolean isNonNullMethod(Symbol symbol) {
        return !symbol.isUnknown() && symbol.metadata().isAnnotatedWith("javax.annotation.Nonnull");
    }

    private void executeVariable(VariableTree variableTree, @Nullable Tree terminator) {
        ExpressionTree initializer = variableTree.initializer();
        if (initializer == null) {
            SymbolicValue sv = null;
            if (terminator != null && terminator.is(Tree.Kind.FOR_EACH_STATEMENT)) {
                sv = this.constraintManager.createSymbolicValue(variableTree);
            } else if (variableTree.type().symbolType().is("boolean")) {
                sv = SymbolicValue.FALSE_LITERAL;
            } else if (variableTree.parent().is(Tree.Kind.CATCH)) {
                sv = this.constraintManager.createSymbolicValue(variableTree);
                this.programState = this.programState.addConstraint(sv, ObjectConstraint.notNull());
            } else if (!variableTree.type().symbolType().isPrimitive()) {
                sv = SymbolicValue.NULL_LITERAL;
            }
            if (sv != null) {
                this.programState = this.programState.put(variableTree.symbol(), sv);
            }
        } else {
            ProgramState.Pop unstack = this.programState.unstackValue(1);
            this.programState = unstack.state;
            this.programState = this.programState.put(variableTree.symbol(), unstack.values.get(0));
        }
    }

    private void executeTypeCast(TypeCastTree typeCast) {
        Type type = typeCast.type().symbolType();
        if (type.isPrimitive()) {
            JavaType expType = (JavaType)typeCast.expression().symbolType();
            SymbolicValue castSV = this.constraintManager.createSymbolicValue(typeCast);
            if (!expType.isPrimitive() || !new Types().isSubtype(expType, (JavaType)type)) {
                ProgramState.Pop unstack = this.programState.unstackValue(1);
                this.programState = unstack.state;
                this.programState = this.programState.stackValue(castSV);
            }
        }
    }

    private void executeAssignement(AssignmentExpressionTree tree) {
        SymbolicValue value;
        ProgramState.Pop unstack;
        ExpressionTree variable = tree.variable();
        if (ExpressionUtils.isSimpleAssignment(tree)) {
            unstack = this.programState.unstackValue(1);
            value = unstack.values.get(0);
        } else {
            unstack = this.programState.unstackValue(2);
            value = this.constraintManager.createSymbolicValue(tree);
        }
        this.programState = unstack.state;
        this.programState = this.programState.stackValue(value);
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            this.programState = this.programState.put(((IdentifierTree)variable).symbol(), value);
        }
    }

    private void executeLogicalAssignment(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            ProgramState.Pop unstack = this.programState.unstackValue(2);
            SymbolicValue assignedTo = unstack.values.get(1);
            SymbolicValue value = unstack.values.get(0);
            this.programState = unstack.state;
            SymbolicValue symbolicValue = this.constraintManager.createSymbolicValue(tree);
            symbolicValue.computedFrom((List<SymbolicValue>)ImmutableList.of((Object)assignedTo, (Object)value));
            this.programState = this.programState.stackValue(symbolicValue);
            this.programState = this.programState.put(((IdentifierTree)variable).symbol(), symbolicValue);
        }
    }

    private void executeArrayAccessExpression(ArrayAccessExpressionTree tree) {
        ProgramState.Pop unstack = this.programState.unstackValue(2);
        this.programState = unstack.state;
        this.programState = this.programState.stackValue(this.constraintManager.createSymbolicValue(tree));
    }

    private void executeNewArray(NewArrayTree newArrayTree) {
        int numberDimensions = (int)newArrayTree.dimensions().stream().map(ArrayDimensionTree::expression).filter(Objects::nonNull).count();
        this.programState = this.programState.unstackValue((int)numberDimensions).state;
        this.programState = this.programState.unstackValue((int)newArrayTree.initializers().size()).state;
        SymbolicValue svNewArray = this.constraintManager.createSymbolicValue(newArrayTree);
        this.programState = this.programState.stackValue(svNewArray);
        this.programState = svNewArray.setSingleConstraint(this.programState, ObjectConstraint.notNull());
    }

    private void executeNewClass(NewClassTree tree) {
        NewClassTree newClassTree = tree;
        this.programState = this.programState.unstackValue((int)newClassTree.arguments().size()).state;
        this.node.programPoint.block.exceptions().forEach(b -> this.enqueue(new ExplodedGraph.ProgramPoint((CFG.Block)b, 0), this.programState, !b.isCatchBlock()));
        SymbolicValue svNewClass = this.constraintManager.createSymbolicValue(newClassTree);
        this.programState = this.programState.stackValue(svNewClass);
        this.programState = svNewClass.setSingleConstraint(this.programState, ObjectConstraint.notNull());
    }

    private void executeBinaryExpression(Tree tree) {
        ProgramState.Pop unstackBinary = this.programState.unstackValue(2);
        this.programState = unstackBinary.state;
        SymbolicValue symbolicValue = this.constraintManager.createSymbolicValue(tree);
        symbolicValue.computedFrom(unstackBinary.values);
        if (tree.is(Tree.Kind.PLUS)) {
            Constraint rightConstraint;
            BinaryExpressionTree bt = (BinaryExpressionTree)tree;
            if (bt.leftOperand().symbolType().is("java.lang.String")) {
                Constraint leftConstraint = this.programState.getConstraint(unstackBinary.values.get(1));
                if (leftConstraint != null && !leftConstraint.isNull()) {
                    List<ProgramState> programStates = symbolicValue.setConstraint(this.programState, ObjectConstraint.notNull());
                    Preconditions.checkState((programStates.size() == 1 ? 1 : 0) != 0);
                    this.programState = programStates.get(0);
                }
            } else if (bt.rightOperand().symbolType().is("java.lang.String") && (rightConstraint = this.programState.getConstraint(unstackBinary.values.get(0))) != null && !rightConstraint.isNull()) {
                List<ProgramState> programStates = symbolicValue.setConstraint(this.programState, ObjectConstraint.notNull());
                Preconditions.checkState((programStates.size() == 1 ? 1 : 0) != 0);
                this.programState = programStates.get(0);
            }
        }
        this.programState = this.programState.stackValue(symbolicValue);
    }

    private void executeUnaryExpression(Tree tree) {
        ProgramState.Pop unstackUnary = this.programState.unstackValue(1);
        this.programState = unstackUnary.state;
        SymbolicValue unarySymbolicValue = this.constraintManager.createSymbolicValue(tree);
        unarySymbolicValue.computedFrom(unstackUnary.values);
        this.programState = tree.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT) ? this.programState.stackValue(unstackUnary.values.get(0)) : this.programState.stackValue(unarySymbolicValue);
        if (tree.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT) && ((UnaryExpressionTree)tree).expression().is(Tree.Kind.IDENTIFIER)) {
            this.programState = this.programState.put(((IdentifierTree)((UnaryExpressionTree)tree).expression()).symbol(), unarySymbolicValue);
        }
    }

    private void executeIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        SymbolicValue value = this.programState.getValue(symbol);
        if (value == null) {
            value = this.constraintManager.createSymbolicValue(tree);
            this.programState = this.programState.stackValue(value);
            this.learnIdentifierNullConstraints(tree, value);
        } else {
            this.programState = this.programState.stackValue(value);
        }
        this.programState = this.programState.put(symbol, value);
    }

    private void learnIdentifierNullConstraints(IdentifierTree tree, SymbolicValue sv) {
        Tree declaration = tree.symbol().declaration();
        if (!ExplodedGraphWalker.isFinalField(tree.symbol()) || declaration == null) {
            return;
        }
        ExpressionTree initializer = ((VariableTree)declaration).initializer();
        if (initializer == null) {
            return;
        }
        if (initializer.is(Tree.Kind.NULL_LITERAL)) {
            this.programState = this.programState.addConstraint(sv, ObjectConstraint.nullConstraint());
        } else if (initializer.is(Tree.Kind.NEW_CLASS) || initializer.is(Tree.Kind.NEW_ARRAY)) {
            this.programState = this.programState.addConstraint(sv, ObjectConstraint.notNull());
        }
    }

    private static boolean isFinalField(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.isFinal() && symbol.owner().isTypeSymbol();
    }

    private void executeMemberSelect(MemberSelectExpressionTree mse) {
        if (!"class".equals(mse.identifier().name())) {
            ProgramState.Pop unstackMSE = this.programState.unstackValue(1);
            this.programState = unstackMSE.state;
        }
        SymbolicValue mseValue = this.constraintManager.createSymbolicValue(mse);
        this.programState = this.programState.stackValue(mseValue);
    }

    public void clearStack(Tree tree) {
        if (tree.parent().is(Tree.Kind.EXPRESSION_STATEMENT)) {
            this.programState = this.programState.clearStack();
        }
    }

    private void setSymbolicValueOnFields(MethodInvocationTree tree) {
        if (ExplodedGraphWalker.isLocalMethodInvocation(tree) || THREAD_SLEEP_MATCHER.matches(tree)) {
            this.resetFieldValues();
        }
    }

    private static boolean isLocalMethodInvocation(MethodInvocationTree tree) {
        ExpressionTree methodSelect = tree.methodSelect();
        if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            return true;
        }
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree memberSelectExpression = (MemberSelectExpressionTree)methodSelect;
            ExpressionTree target = memberSelectExpression.expression();
            if (target.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree identifier = (IdentifierTree)target;
                return THIS_SUPER.contains(identifier.name());
            }
        }
        return false;
    }

    private void resetFieldValues() {
        this.programState = this.programState.resetFieldValues(this.constraintManager);
    }

    private void logState(MethodInvocationTree mit) {
        if (mit.methodSelect().is(Tree.Kind.IDENTIFIER) && "printState".equals(((IdentifierTree)mit.methodSelect()).name())) {
            ExplodedGraphWalker.debugPrint(((JavaTree)((Object)mit)).getLine(), this.node);
        }
    }

    private static void debugPrint(Object ... toPrint) {
    }

    public void enqueue(ExplodedGraph.ProgramPoint programPoint, ProgramState programState) {
        this.enqueue(programPoint, programState, false);
    }

    public void enqueue(ExplodedGraph.ProgramPoint newProgramPoint, ProgramState programState, boolean exitPath) {
        ExplodedGraph.ProgramPoint programPoint = newProgramPoint;
        int nbOfExecution = programState.numberOfTimeVisited(programPoint);
        if (nbOfExecution > 2) {
            if (ExplodedGraphWalker.isRestartingForEachLoop(programPoint)) {
                programPoint = new ExplodedGraph.ProgramPoint(programPoint.block.falseBlock(), 0);
            } else {
                ExplodedGraphWalker.debugPrint(programPoint);
                return;
            }
        }
        this.checkExplodedGraphTooBig(programState);
        ProgramState ps = programState.visitedPoint(programPoint, nbOfExecution + 1);
        ps.lastEvaluated = programState.getLastEvaluated();
        ExplodedGraph.Node cachedNode = this.explodedGraph.getNode(programPoint, ps);
        if (!cachedNode.isNew && exitPath == cachedNode.exitPath) {
            cachedNode.addParent(this.node);
            return;
        }
        cachedNode.exitPath = exitPath;
        if (this.node != null) {
            cachedNode.happyPath = this.node.happyPath;
        }
        cachedNode.setParent(this.node);
        this.workList.addFirst(cachedNode);
    }

    private static boolean isRestartingForEachLoop(ExplodedGraph.ProgramPoint programPoint) {
        Tree terminator = programPoint.block.terminator();
        return terminator != null && terminator.is(Tree.Kind.FOR_EACH_STATEMENT);
    }

    private void checkExplodedGraphTooBig(ProgramState programState) {
        if (this.steps + this.workList.size() > 8000 && programState.constraintsSize() > 75) {
            throw new ExplodedGraphTooBigException("Program state constraints are too big : stopping Symbolic Execution for method " + this.methodTree.simpleName().name() + " in class " + this.methodTree.symbol().owner().name());
        }
    }

    public static class ExplodedGraphWalkerFactory {
        private final ConditionAlwaysTrueOrFalseCheck alwaysTrueOrFalseChecker;
        @VisibleForTesting
        final List<SECheck> seChecks = new ArrayList<SECheck>();

        public ExplodedGraphWalkerFactory(List<JavaFileScanner> scanners) {
            ArrayList<SECheck> checks = new ArrayList<SECheck>();
            for (JavaFileScanner scanner : scanners) {
                if (!(scanner instanceof SECheck)) continue;
                checks.add((SECheck)scanner);
            }
            this.alwaysTrueOrFalseChecker = ExplodedGraphWalkerFactory.removeOrDefault(checks, new ConditionAlwaysTrueOrFalseCheck());
            this.seChecks.add(this.alwaysTrueOrFalseChecker);
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new NullDereferenceCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new DivisionByZeroCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new UnclosedResourcesCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new LocksNotUnlockedCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new NonNullSetToNullCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new NoWayOutLoopCheck()));
            this.seChecks.add(ExplodedGraphWalkerFactory.removeOrDefault(checks, new OptionalGetBeforeIsPresentCheck()));
            this.seChecks.addAll(checks);
        }

        public ExplodedGraphWalker createWalker(SymbolicExecutionVisitor symbolicExecutionVisitor) {
            return new ExplodedGraphWalker(this.alwaysTrueOrFalseChecker, this.seChecks, symbolicExecutionVisitor);
        }

        private static <T extends SECheck> T removeOrDefault(List<SECheck> checks, T defaultInstance) {
            Iterator<SECheck> iterator = checks.iterator();
            while (iterator.hasNext()) {
                SECheck check = iterator.next();
                if (!check.getClass().equals(defaultInstance.getClass())) continue;
                iterator.remove();
                return (T)check;
            }
            return defaultInstance;
        }
    }

    public static class TooManyNestedBooleanStatesException
    extends RuntimeException {
    }

    public static class MaximumStepsReachedException
    extends RuntimeException {
        public MaximumStepsReachedException(String s) {
            super(s);
        }

        public MaximumStepsReachedException(String s, TooManyNestedBooleanStatesException e) {
            super(s, e);
        }
    }

    public static class ExplodedGraphTooBigException
    extends RuntimeException {
        public ExplodedGraphTooBigException(String s) {
            super(s);
        }
    }
}

