/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.se.MethodYield;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;

public class MethodBehavior {
    private final Symbol.MethodSymbol methodSymbol;
    private final Set<MethodYield> yields;
    private final Map<Symbol, SymbolicValue> parameters;
    private boolean complete = false;

    public MethodBehavior(Symbol.MethodSymbol methodSymbol) {
        this.methodSymbol = methodSymbol;
        this.yields = new LinkedHashSet<MethodYield>();
        this.parameters = new LinkedHashMap<Symbol, SymbolicValue>();
    }

    public void createYield(ProgramState programState, boolean happyPathYield) {
        MethodYield yield = new MethodYield(this.parameters.size(), ((JavaSymbol.MethodJavaSymbol)this.methodSymbol).isVarArgs());
        yield.exception = !happyPathYield;
        ArrayList<SymbolicValue> parameterSymbolicValues = new ArrayList<SymbolicValue>(this.parameters.values());
        for (int i = 0; i < yield.parametersConstraints.length; ++i) {
            yield.parametersConstraints[i] = programState.getConstraint((SymbolicValue)parameterSymbolicValues.get(i));
        }
        SymbolicValue resultSV = programState.exitValue();
        if (resultSV instanceof SymbolicValue.ExceptionalSymbolicValue) {
            yield.exception = true;
            yield.exceptionType = ((SymbolicValue.ExceptionalSymbolicValue)resultSV).exceptionType();
        } else if (!this.isConstructor() && !this.isVoidMethod()) {
            if (resultSV == null) {
                yield.exception = true;
            } else {
                yield.resultIndex = parameterSymbolicValues.indexOf(resultSV);
                yield.resultConstraint = programState.getConstraint(resultSV);
            }
        }
        this.yields.add(yield);
    }

    private boolean isVoidMethod() {
        return this.methodSymbol.returnType().type().isVoid();
    }

    private boolean isConstructor() {
        return ((JavaSymbol.MethodJavaSymbol)this.methodSymbol).isConstructor();
    }

    List<MethodYield> yields() {
        return ImmutableList.builder().addAll(this.yields).build();
    }

    Stream<MethodYield> exceptionalPathYields() {
        return this.yields.stream().filter(y -> y.exception);
    }

    Stream<MethodYield> happyPathYields() {
        return this.yields.stream().filter(y -> !y.exception);
    }

    public void addParameter(Symbol symbol, SymbolicValue sv) {
        this.parameters.put(symbol, sv);
    }

    public Collection<SymbolicValue> parameters() {
        return this.parameters.values();
    }

    public boolean isComplete() {
        return this.complete;
    }

    void completed() {
        this.complete = true;
    }
}

