/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.MethodBehavior;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SymbolicExecutionVisitor
extends SubscriptionVisitor {
    private static final Logger LOG = Loggers.get(SymbolicExecutionVisitor.class);
    @VisibleForTesting
    final Map<Symbol.MethodSymbol, MethodBehavior> behaviorCache = new LinkedHashMap<Symbol.MethodSymbol, MethodBehavior>();
    private final ExplodedGraphWalker.ExplodedGraphWalkerFactory egwFactory;

    public SymbolicExecutionVisitor(List<JavaFileScanner> executableScanners) {
        this.egwFactory = new ExplodedGraphWalker.ExplodedGraphWalkerFactory(executableScanners);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Lists.newArrayList((Object[])new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR});
    }

    @Override
    public void visitNode(Tree tree) {
        this.execute((MethodTree)tree);
    }

    @CheckForNull
    public MethodBehavior execute(MethodTree methodTree) {
        try {
            MethodBehavior methodBehavior = this.behaviorCache.get(methodTree.symbol());
            if (methodBehavior == null) {
                methodBehavior = new MethodBehavior(methodTree.symbol());
                this.behaviorCache.put(methodTree.symbol(), methodBehavior);
                ExplodedGraphWalker walker = this.egwFactory.createWalker(this);
                methodBehavior = walker.visitMethod(methodTree, methodBehavior);
                methodBehavior.completed();
            }
            return methodBehavior;
        }
        catch (ExplodedGraphWalker.ExplodedGraphTooBigException | ExplodedGraphWalker.MaximumStepsReachedException | BinaryRelation.TransitiveRelationExceededException exception) {
            LOG.debug("Could not complete symbolic execution: ", (Object)exception);
            return null;
        }
    }
}

