/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.FlowComputation;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S3518")
public class DivisionByZeroCheck
extends SECheck {
    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitLiteral(LiteralTree tree) {
            String value = tree.value();
            SymbolicValue sv = this.programState.peekValue();
            if (tree.is(Tree.Kind.CHAR_LITERAL) && PostStatementVisitor.isNullCharacter(value)) {
                this.addZeroConstraint(sv, DivByZeroStatus.ZERO);
            } else if (tree.is(Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL)) {
                this.addZeroConstraint(sv, PostStatementVisitor.isNumberZero(value) ? DivByZeroStatus.ZERO : DivByZeroStatus.NON_ZERO);
            }
        }

        private static boolean isNumberZero(String literalValue) {
            return !literalValue.matches("(.)*[1-9]+(.)*") && !literalValue.matches("(0x|0X){1}(.)*[1-9a-fA-F]+(.)*") && !literalValue.matches("(0b|0B){1}(.)*[1]+(.)*");
        }

        private static boolean isNullCharacter(String literalValue) {
            return "'\\0'".equals(literalValue) || "'\\u0000'".equals(literalValue);
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        @Override
        public void visitUnaryExpression(UnaryExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        @Override
        public void visitTypeCast(TypeCastTree tree) {
            this.checkDeferredConstraint();
        }

        private void checkDeferredConstraint() {
            SymbolicValue sv = this.programState.peekValue();
            if (sv instanceof DeferredStatusHolderSV) {
                this.addZeroConstraint(sv, ((DeferredStatusHolderSV)sv).deferredStatus);
            }
        }

        private void addZeroConstraint(SymbolicValue sv, DivByZeroStatus status) {
            this.programState = this.programState.addConstraint(sv, new ZeroConstraint(status));
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final ConstraintManager constraintManager;
        private final CheckerContext context;

        PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
            this.constraintManager = context.getConstraintManager();
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            SymbolicValue expr;
            SymbolicValue var;
            if (ExpressionUtils.isSimpleAssignment(tree)) {
                var = this.programState.getValue(((IdentifierTree)ExpressionUtils.skipParentheses(tree.variable())).symbol());
                expr = this.programState.peekValue();
            } else {
                List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
                var = symbolicValues.get(1);
                expr = symbolicValues.get(0);
            }
            this.checkExpression(tree, var, expr);
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            switch (tree.kind()) {
                case MULTIPLY: 
                case PLUS: 
                case MINUS: 
                case DIVIDE: 
                case REMAINDER: {
                    List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
                    this.checkExpression(tree, symbolicValues.get(1), symbolicValues.get(0));
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL_TO: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL_TO: {
                    List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
                    this.setAsUndetermined(symbolicValues.get(1));
                    this.setAsUndetermined(symbolicValues.get(0));
                    break;
                }
            }
        }

        private void setAsUndetermined(SymbolicValue sv) {
            this.programState = this.programState.addConstraint(sv, new ZeroConstraint(DivByZeroStatus.UNDETERMINED));
        }

        private void checkExpression(Tree tree, SymbolicValue leftOp, SymbolicValue rightOp) {
            switch (tree.kind()) {
                case MULTIPLY: 
                case MULTIPLY_ASSIGNMENT: {
                    this.handleMultiply(leftOp, rightOp);
                    break;
                }
                case PLUS: 
                case MINUS: 
                case PLUS_ASSIGNMENT: 
                case MINUS_ASSIGNMENT: {
                    this.handlePlusMinus(leftOp, rightOp);
                    break;
                }
                case DIVIDE: 
                case REMAINDER: 
                case DIVIDE_ASSIGNMENT: 
                case REMAINDER_ASSIGNMENT: {
                    this.handleDivide(tree, leftOp, rightOp);
                    break;
                }
            }
        }

        private boolean isZero(SymbolicValue symbolicValue) {
            return this.hasStatus(symbolicValue, DivByZeroStatus.ZERO);
        }

        private boolean isNonZero(SymbolicValue symbolicValue) {
            return this.hasStatus(symbolicValue, DivByZeroStatus.NON_ZERO);
        }

        private boolean hasStatus(SymbolicValue symbolicValue, DivByZeroStatus status) {
            return this.programState.getConstraintWithStatus(symbolicValue, status) != null;
        }

        private void handleMultiply(SymbolicValue left, SymbolicValue right) {
            boolean leftIsZero = this.isZero(left);
            if (leftIsZero || this.isZero(right)) {
                this.reuseSymbolicValue(leftIsZero ? left : right);
            } else if (this.isNonZero(left) && this.isNonZero(right)) {
                this.deferConstraint(DivByZeroStatus.NON_ZERO);
            }
        }

        private void handlePlusMinus(SymbolicValue left, SymbolicValue right) {
            boolean leftIsZero = this.isZero(left);
            if (leftIsZero || this.isZero(right)) {
                this.reuseSymbolicValue(leftIsZero ? right : left);
            }
        }

        private void handleDivide(Tree tree, SymbolicValue leftOp, SymbolicValue rightOp) {
            if (this.isZero(rightOp)) {
                this.reportIssue(tree, rightOp);
            } else if (this.isZero(leftOp)) {
                this.reuseSymbolicValue(leftOp);
            } else if (this.isNonZero(leftOp) && this.isNonZero(rightOp)) {
                this.deferConstraint(tree.is(Tree.Kind.DIVIDE, Tree.Kind.DIVIDE_ASSIGNMENT) ? DivByZeroStatus.NON_ZERO : DivByZeroStatus.UNDETERMINED);
            }
        }

        private void deferConstraint(DivByZeroStatus status) {
            this.constraintManager.setValueFactory(id -> new DeferredStatusHolderSV(id, status));
        }

        private void reuseSymbolicValue(final SymbolicValue sv) {
            this.constraintManager.setValueFactory(id -> new DeferredStatusHolderSV(id, this.statusFromSV(sv)){

                @Override
                public SymbolicValue wrappedValue() {
                    return sv.wrappedValue();
                }
            });
        }

        private DivByZeroStatus statusFromSV(SymbolicValue sv) {
            return this.isZero(sv) ? DivByZeroStatus.ZERO : (this.isNonZero(sv) ? DivByZeroStatus.NON_ZERO : DivByZeroStatus.UNDETERMINED);
        }

        private void reportIssue(Tree tree, SymbolicValue denominator) {
            String flowMessage;
            String expressionName;
            String operation;
            ExpressionTree expression = this.getDenominator(tree);
            String string = operation = tree.is(Tree.Kind.REMAINDER, Tree.Kind.REMAINDER_ASSIGNMENT) ? "modulation" : "division";
            if (expression.is(Tree.Kind.IDENTIFIER)) {
                String name = ((IdentifierTree)expression).name();
                expressionName = "'" + name + "'";
                flowMessage = name + " is divided by zero";
            } else {
                expressionName = "this expression";
                flowMessage = "this expression contains division by zero";
            }
            List<JavaFileScannerContext.Location> flow = FlowComputation.flow(this.context.getNode(), denominator);
            flow.add(0, new JavaFileScannerContext.Location(flowMessage, tree));
            this.context.reportIssue(expression, DivisionByZeroCheck.this, "Make sure " + expressionName + " can't be zero before doing this " + operation + ".", (Set<List<JavaFileScannerContext.Location>>)ImmutableSet.of(flow));
            this.programState = null;
        }

        private ExpressionTree getDenominator(Tree tree) {
            return tree.is(Tree.Kind.DIVIDE, Tree.Kind.REMAINDER) ? ((BinaryExpressionTree)tree).rightOperand() : ((AssignmentExpressionTree)tree).expression();
        }

        @Override
        public void visitTypeCast(TypeCastTree tree) {
            Type type = tree.type().symbolType();
            if (type.isPrimitive()) {
                SymbolicValue sv = this.programState.peekValue();
                if (this.isZero(sv)) {
                    this.reuseSymbolicValue(sv);
                } else if (this.isNonZero(sv)) {
                    this.deferConstraint(DivByZeroStatus.NON_ZERO);
                }
            }
        }

        @Override
        public void visitUnaryExpression(UnaryExpressionTree tree) {
            if (!tree.is(Tree.Kind.LOGICAL_COMPLEMENT)) {
                SymbolicValue sv = this.programState.peekValue();
                if (this.isZero(sv)) {
                    if (tree.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
                        this.reuseSymbolicValue(sv);
                    } else {
                        this.deferConstraint(DivByZeroStatus.NON_ZERO);
                    }
                } else {
                    this.deferConstraint(DivByZeroStatus.UNDETERMINED);
                }
            }
        }
    }

    private static class ZeroConstraint
    extends ObjectConstraint<DivByZeroStatus> {
        private ZeroConstraint(DivByZeroStatus status) {
            super(false, false, status);
        }

        @Override
        public boolean isInvalidWith(@Nullable Constraint constraint) {
            return this.hasStatus(DivByZeroStatus.ZERO) && constraint instanceof ObjectConstraint && ((ObjectConstraint)constraint).hasStatus(DivByZeroStatus.ZERO);
        }
    }

    private static class DeferredStatusHolderSV
    extends SymbolicValue {
        private final DivByZeroStatus deferredStatus;

        public DeferredStatusHolderSV(int id, DivByZeroStatus deferredStatus) {
            super(id);
            this.deferredStatus = deferredStatus;
        }
    }

    private static enum DivByZeroStatus implements ObjectConstraint.Status
    {
        ZERO{

            @Override
            public String valueAsString() {
                return "zero";
            }
        }
        ,
        NON_ZERO,
        UNDETERMINED;

    }
}

