/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Tree;

public class FlowComputation {
    private final Predicate<Constraint> addToFlow;
    private final Predicate<Constraint> terminateTraversal;
    private final List<JavaFileScannerContext.Location> flow = new ArrayList<JavaFileScannerContext.Location>();
    private final SymbolicValue symbolicValue;
    private final Set<ExplodedGraph.Node> visited = new HashSet<ExplodedGraph.Node>();

    private FlowComputation(SymbolicValue symbolicValue, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal) {
        this.addToFlow = addToFlow;
        this.terminateTraversal = terminateTraversal;
        this.symbolicValue = symbolicValue;
    }

    public static List<JavaFileScannerContext.Location> flow(ExplodedGraph.Node currentNode, SymbolicValue currentVal) {
        return FlowComputation.flow(currentNode, currentVal, constraint -> true);
    }

    public static List<JavaFileScannerContext.Location> flow(ExplodedGraph.Node currentNode, SymbolicValue currentVal, Predicate<Constraint> addToFlow) {
        return FlowComputation.flow(currentNode, currentVal, addToFlow, c -> false);
    }

    public static List<JavaFileScannerContext.Location> flow(ExplodedGraph.Node currentNode, SymbolicValue currentVal, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal) {
        FlowComputation flowComputation = new FlowComputation(currentVal, addToFlow, terminateTraversal);
        Symbol trackSymbol = currentNode.programState.getLastEvaluated();
        if (currentVal instanceof BinarySymbolicValue) {
            Set<JavaFileScannerContext.Location> binSVFlow = flowComputation.flowFromBinarySV(currentNode, (BinarySymbolicValue)currentVal, trackSymbol);
            flowComputation.flow.addAll(binSVFlow);
        }
        flowComputation.run(currentNode, trackSymbol);
        return flowComputation.flow;
    }

    private Set<JavaFileScannerContext.Location> flowFromBinarySV(ExplodedGraph.Node currentNode, BinarySymbolicValue binarySV, Symbol trackSymbol) {
        HashSet<JavaFileScannerContext.Location> binSVFlow = new HashSet<JavaFileScannerContext.Location>();
        FlowComputation left = this.fork(binarySV.getLeftOp());
        left.run(currentNode.parent(), trackSymbol);
        binSVFlow.addAll(left.flow);
        FlowComputation right = this.fork(binarySV.getRightOp());
        right.run(currentNode.parent(), trackSymbol);
        binSVFlow.addAll(right.flow);
        return binSVFlow;
    }

    private FlowComputation fork(SymbolicValue symbolicValue) {
        return new FlowComputation(symbolicValue, this.addToFlow, this.terminateTraversal);
    }

    private void run(@Nullable ExplodedGraph.Node currentNode, @Nullable Symbol trackSymbol) {
        if (currentNode == null || this.visited.contains(currentNode)) {
            return;
        }
        this.visited.add(currentNode);
        Symbol newTrackSymbol = trackSymbol;
        if (currentNode.programPoint.syntaxTree() != null) {
            newTrackSymbol = this.flowFromLearnedSymbols(currentNode, trackSymbol);
            List<Constraint> learnedConstraints = this.flowFromLearnedConstraints(currentNode);
            if (learnedConstraints.stream().anyMatch(this.terminateTraversal)) {
                return;
            }
        }
        for (ExplodedGraph.Node parent : currentNode.getParents()) {
            this.run(parent, newTrackSymbol);
        }
    }

    private List<Constraint> flowFromLearnedConstraints(ExplodedGraph.Node currentNode) {
        List<Constraint> learnedConstraints = currentNode.getLearnedConstraints().stream().filter(lc -> lc.getSv().equals(this.symbolicValue)).map(ExplodedGraph.Node.LearnedConstraint::getConstraint).collect(Collectors.toList());
        if (learnedConstraints.stream().anyMatch(this.addToFlow)) {
            this.flow.add(FlowComputation.location(currentNode.parent()));
        }
        return learnedConstraints;
    }

    @Nullable
    private Symbol flowFromLearnedSymbols(ExplodedGraph.Node currentNode, @Nullable Symbol trackSymbol) {
        ExplodedGraph.Node parent = currentNode.parent();
        if (trackSymbol == null || parent == null) {
            return null;
        }
        Optional<ExplodedGraph.Node.LearnedValue> learnedValue = currentNode.getLearnedSymbols().stream().filter(lv -> lv.getSymbol().equals(trackSymbol)).findFirst();
        if (learnedValue.isPresent()) {
            ExplodedGraph.Node.LearnedValue lv2 = learnedValue.get();
            Constraint constraint = parent.programState.getConstraint(lv2.getSv());
            JavaFileScannerContext.Location location = constraint == null ? FlowComputation.location(parent) : FlowComputation.location(parent, lv2.getSymbol().name() + " is assigned " + constraint.valueAsString());
            this.flow.add(location);
            return parent.programState.getLastEvaluated();
        }
        return trackSymbol;
    }

    private static JavaFileScannerContext.Location location(ExplodedGraph.Node node) {
        return FlowComputation.location(node, "...");
    }

    private static JavaFileScannerContext.Location location(ExplodedGraph.Node node, String message) {
        return new JavaFileScannerContext.Location(message, node.programPoint.syntaxTree());
    }

    static Set<List<JavaFileScannerContext.Location>> singleton(String msg, Tree tree) {
        return ImmutableSet.of((Object)ImmutableList.of((Object)new JavaFileScannerContext.Location(msg, tree)));
    }
}

