/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.FlowComputation;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2259")
public class NullDereferenceCheck
extends SECheck {
    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        SymbolicValue currentVal = context.getState().peekValue();
        if (currentVal == null) {
            return context.getState();
        }
        Tree toCheck = syntaxNode;
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)syntaxNode;
            toCheck = methodInvocation.methodSelect();
            int numberArguments = methodInvocation.arguments().size();
            List<SymbolicValue> values = context.getState().peekValues(numberArguments + 1);
            currentVal = values.get(numberArguments);
            if (NullDereferenceCheck.isObjectsRequireNonNullMethod(methodInvocation.symbol())) {
                SymbolicValue firstArg = values.get(numberArguments - 1);
                return context.getState().addConstraint(firstArg, ObjectConstraint.notNull());
            }
        }
        if (toCheck.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
            toCheck = ((ArrayAccessExpressionTree)toCheck).expression();
            currentVal = context.getState().peekValues(2).get(1);
            return this.checkConstraint(context, toCheck, currentVal);
        }
        if (toCheck.is(Tree.Kind.MEMBER_SELECT)) {
            return this.checkMemberSelect(context, (MemberSelectExpressionTree)toCheck, currentVal);
        }
        return context.getState();
    }

    private static boolean isObjectsRequireNonNullMethod(Symbol symbol) {
        return symbol.isMethodSymbol() && symbol.owner().type().is("java.util.Objects") && "requireNonNull".equals(symbol.name());
    }

    private ProgramState checkMemberSelect(CheckerContext context, MemberSelectExpressionTree mse, SymbolicValue currentVal) {
        if ("class".equals(mse.identifier().name())) {
            return context.getState();
        }
        return this.checkConstraint(context, mse, currentVal);
    }

    private ProgramState checkConstraint(CheckerContext context, Tree syntaxNode, SymbolicValue currentVal) {
        ProgramState programState = context.getState();
        Constraint constraint = programState.getConstraint(currentVal);
        if (constraint != null && constraint.isNull()) {
            String symbolName = SyntaxTreeNameFinder.getName(syntaxNode);
            String message = "NullPointerException might be thrown as '" + symbolName + "' is nullable here";
            SymbolicValue val = null;
            if (!SymbolicValue.NULL_LITERAL.equals(currentVal)) {
                val = currentVal;
            }
            List<JavaFileScannerContext.Location> flow = FlowComputation.flow(context.getNode(), val);
            NullDereferenceCheck.addDereferenceMessage(flow, syntaxNode);
            this.reportIssue(syntaxNode, message, (Set<List<JavaFileScannerContext.Location>>)ImmutableSet.of(flow));
            return null;
        }
        constraint = programState.getConstraint(currentVal);
        if (constraint == null) {
            return programState.addConstraint(currentVal, ObjectConstraint.notNull());
        }
        return programState;
    }

    private static void addDereferenceMessage(List<JavaFileScannerContext.Location> flow, Tree syntaxNode) {
        String symbolName = SyntaxTreeNameFinder.getName(syntaxNode);
        String msg = syntaxNode.is(Tree.Kind.MEMBER_SELECT) && ((MemberSelectExpressionTree)syntaxNode).expression().is(Tree.Kind.METHOD_INVOCATION) ? String.format("Result of %s() is dereferenced", symbolName) : String.format("%s is dereferenced", symbolName);
        flow.add(0, new JavaFileScannerContext.Location(msg, syntaxNode));
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT) && context.getConstraintManager().isNull(context.getState(), context.getState().peekValue())) {
            context.reportIssue(syntaxNode, this, "NullPointerException might be thrown as '" + SyntaxTreeNameFinder.getName(syntaxNode) + "' is nullable here");
            context.createSink();
            return context.getState();
        }
        List<ProgramState> programStates = NullDereferenceCheck.setNullConstraint(context, syntaxNode);
        for (ProgramState programState : programStates) {
            context.addTransition(programState);
        }
        return context.getState();
    }

    private static List<ProgramState> setNullConstraint(CheckerContext context, Tree syntaxNode) {
        SymbolicValue val = context.getState().peekValue();
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION) && NullDereferenceCheck.isAnnotatedCheckForNull((MethodInvocationTree)syntaxNode)) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.nullConstraint()));
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.notNull()));
            return states;
        }
        return Lists.newArrayList((Object[])new ProgramState[]{context.getState()});
    }

    private static boolean isAnnotatedCheckForNull(MethodInvocationTree syntaxNode) {
        return syntaxNode.symbol().metadata().isAnnotatedWith("javax.annotation.CheckForNull");
    }
}

