/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValueFactory;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.FlowComputation;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2095")
public class UnclosedResourcesCheck
extends SECheck {
    @RuleProperty(key="excludedResourceTypes", description="Comma separated list of the excluded resource types, using fully qualified names (example: \"org.apache.hadoop.fs.FileSystem\")", defaultValue="")
    public String excludedTypes = "";
    private final List<String> excludedTypesList = new ArrayList<String>();
    private static final String JAVA_IO_AUTO_CLOSEABLE = "java.lang.AutoCloseable";
    private static final String JAVA_IO_CLOSEABLE = "java.io.Closeable";
    private static final String JAVA_SQL_STATEMENT = "java.sql.Statement";
    private static final String[] JDBC_RESOURCE_CREATIONS = new String[]{"java.sql.Connection", "java.sql.Statement"};
    private static final String STREAM_TOP_HIERARCHY = "java.util.stream.BaseStream";
    private static final String[] IGNORED_CLOSEABLE_SUBTYPES = new String[]{"java.io.ByteArrayOutputStream", "java.io.ByteArrayInputStream", "java.io.CharArrayReader", "java.io.CharArrayWriter", "java.io.StringReader", "java.io.StringWriter", "com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream", "org.springframework.context.ConfigurableApplicationContext"};
    private static final MethodMatcher[] CLOSEABLE_EXCEPTIONS = new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.nio.file.FileSystems").name("getDefault").withoutParameter()};

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        ExplodedGraph.Node node = context.getNode();
        context.getState().getValuesWithConstraints(Status.OPENED).forEach((sv, c) -> this.processUnclosedSymbolicValue(node, (SymbolicValue)sv));
    }

    private void processUnclosedSymbolicValue(ExplodedGraph.Node node, SymbolicValue sv) {
        FlowComputation.flow(node, sv, ObjectConstraint.statusPredicate(Status.OPENED)).stream().filter(location -> location.syntaxNode.is(Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION)).forEach(this::reportIssue);
    }

    private void reportIssue(JavaFileScannerContext.Location location) {
        String message = "Close this \"" + UnclosedResourcesCheck.name(location.syntaxNode) + "\".";
        String flowMessage = UnclosedResourcesCheck.name(location.syntaxNode) + " is never closed";
        Set<List<JavaFileScannerContext.Location>> flows = FlowComputation.singleton(flowMessage, location.syntaxNode);
        this.reportIssue(location.syntaxNode, message, flows);
    }

    private static String name(Tree tree) {
        if (tree.is(Tree.Kind.NEW_CLASS)) {
            return ((NewClassTree)tree).symbolType().name();
        }
        return ((MethodInvocationTree)tree).symbolType().name();
    }

    private boolean needsClosing(Type type) {
        if (type.isSubtypeOf(STREAM_TOP_HIERARCHY)) {
            return false;
        }
        for (String ignoredTypes : IGNORED_CLOSEABLE_SUBTYPES) {
            if (!type.isSubtypeOf(ignoredTypes)) continue;
            return false;
        }
        for (String excludedType : this.loadExcludedTypesList()) {
            if (!type.is(excludedType)) continue;
            return false;
        }
        return UnclosedResourcesCheck.isCloseable(type);
    }

    private List<String> loadExcludedTypesList() {
        if (this.excludedTypesList.isEmpty() && !StringUtils.isBlank((String)this.excludedTypes)) {
            for (String excludedType : this.excludedTypes.split(",")) {
                this.excludedTypesList.add(excludedType.trim());
            }
        }
        return this.excludedTypesList;
    }

    private static boolean isCloseable(Type type) {
        return type.isSubtypeOf(JAVA_IO_AUTO_CLOSEABLE) || type.isSubtypeOf(JAVA_IO_CLOSEABLE);
    }

    private boolean isOpeningResource(NewClassTree syntaxNode) {
        if (UnclosedResourcesCheck.isWithinTryHeader(syntaxNode)) {
            return false;
        }
        return this.needsClosing(syntaxNode.symbolType());
    }

    private static boolean isWithinTryHeader(Tree syntaxNode) {
        Tree parent = syntaxNode.parent();
        if (parent.is(Tree.Kind.VARIABLE)) {
            return UnclosedResourcesCheck.isTryStatementResource((VariableTree)parent);
        }
        return false;
    }

    private static boolean isTryStatementResource(VariableTree variable) {
        TryStatementTree tryStatement = UnclosedResourcesCheck.getEnclosingTryStatement(variable);
        return tryStatement != null && tryStatement.resources().contains(variable);
    }

    private static TryStatementTree getEnclosingTryStatement(Tree syntaxNode) {
        for (Tree parent = syntaxNode.parent(); parent != null; parent = parent.parent()) {
            if (!parent.is(Tree.Kind.TRY_STATEMENT)) continue;
            return (TryStatementTree)parent;
        }
        return null;
    }

    private class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitNewClass(NewClassTree syntaxNode) {
            SymbolicValue instanceValue;
            if (UnclosedResourcesCheck.this.isOpeningResource(syntaxNode) && !((instanceValue = this.programState.peekValue()) instanceof ResourceWrapperSymbolicValue)) {
                this.programState = this.programState.addConstraint(instanceValue, new ObjectConstraint<Status>(false, false, Status.OPENED));
            }
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            ExpressionTree targetExpression;
            for (MethodMatcher matcher : CLOSEABLE_EXCEPTIONS) {
                if (!matcher.matches(syntaxNode)) continue;
                return;
            }
            if (syntaxNode.methodSelect().is(Tree.Kind.MEMBER_SELECT) && UnclosedResourcesCheck.this.needsClosing(syntaxNode.symbolType()) && (targetExpression = ((MemberSelectExpressionTree)syntaxNode.methodSelect()).expression()).is(Tree.Kind.IDENTIFIER) && !UnclosedResourcesCheck.isWithinTryHeader(syntaxNode) && (syntaxNode.symbol().isStatic() || this.isJdbcResourceCreation(targetExpression))) {
                this.programState = this.programState.addConstraint(this.programState.peekValue(), new ObjectConstraint<Status>(false, false, Status.OPENED));
            }
        }

        private boolean isJdbcResourceCreation(ExpressionTree targetExpression) {
            for (String creator : JDBC_RESOURCE_CREATIONS) {
                if (!targetExpression.symbolType().is(creator)) continue;
                return true;
            }
            return false;
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private static final String CLOSE = "close";
        private static final String GET_MORE_RESULTS = "getMoreResults";
        private static final String GET_RESULT_SET = "getResultSet";
        private final ConstraintManager constraintManager;

        PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.constraintManager = context.getConstraintManager();
        }

        @Override
        public void visitNewClass(NewClassTree syntaxNode) {
            ArrayList<SymbolicValue> arguments = new ArrayList<SymbolicValue>(this.programState.peekValues(syntaxNode.arguments().size()));
            Collections.reverse(arguments);
            if (UnclosedResourcesCheck.this.isOpeningResource(syntaxNode)) {
                Iterator iterator = arguments.iterator();
                for (ExpressionTree argument : syntaxNode.arguments()) {
                    if (!iterator.hasNext()) {
                        throw new IllegalStateException("Mismatch between declared constructor arguments and argument values!");
                    }
                    Type type = argument.symbolType();
                    SymbolicValue value = (SymbolicValue)iterator.next();
                    if (!UnclosedResourcesCheck.isCloseable(type)) continue;
                    this.constraintManager.setValueFactory(new WrappedValueFactory(value));
                    break;
                }
            } else {
                this.closeArguments(syntaxNode.arguments());
            }
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree syntaxNode) {
            ExpressionTree expression;
            SymbolicValue currentVal = this.programState.peekValue();
            if (currentVal != null && (expression = syntaxNode.expression()) != null) {
                if (expression.is(Tree.Kind.IDENTIFIER)) {
                    IdentifierTree identifier = (IdentifierTree)expression;
                    currentVal = this.programState.getValue(identifier.symbol());
                } else {
                    currentVal = this.programState.peekValue();
                }
                this.closeResource(currentVal);
            }
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree syntaxNode) {
            ExpressionTree variable = syntaxNode.variable();
            if (this.isNonLocalStorage(variable)) {
                SymbolicValue value = ExpressionUtils.isSimpleAssignment(syntaxNode) ? this.programState.peekValue() : this.programState.peekValues(2).get(0);
                this.closeResource(value);
            }
        }

        private boolean isNonLocalStorage(ExpressionTree variable) {
            if (variable.is(Tree.Kind.IDENTIFIER)) {
                Symbol owner = ((IdentifierTree)variable).symbol().owner();
                return !owner.isMethodSymbol();
            }
            return true;
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            Symbol symbol = syntaxNode.symbol();
            if (symbol.isMethodSymbol() && syntaxNode.methodSelect().is(Tree.Kind.MEMBER_SELECT)) {
                String methodName = symbol.name();
                SymbolicValue value = this.getTargetValue(syntaxNode);
                if (CLOSE.equals(methodName)) {
                    this.closeResource(value);
                } else if (GET_MORE_RESULTS.equals(methodName)) {
                    this.closeResultSetsRelatedTo(value);
                } else if (GET_RESULT_SET.equals(methodName)) {
                    this.constraintManager.setValueFactory(new WrappedValueFactory(value));
                }
            }
            this.closeArguments(syntaxNode.arguments());
        }

        private SymbolicValue getTargetValue(MethodInvocationTree syntaxNode) {
            SymbolicValue value;
            ExpressionTree targetExpression = ((MemberSelectExpressionTree)syntaxNode.methodSelect()).expression();
            if (targetExpression.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree identifier = (IdentifierTree)targetExpression;
                value = this.programState.getValue(identifier.symbol());
            } else {
                value = this.programState.peekValue();
            }
            return value;
        }

        private void closeResultSetsRelatedTo(SymbolicValue value) {
            for (Map.Entry<SymbolicValue, ObjectConstraint> constrainedValue : this.programState.getValuesWithConstraints(Status.OPENED).entrySet()) {
                ResourceWrapperSymbolicValue rValue;
                if (!(constrainedValue.getKey() instanceof ResourceWrapperSymbolicValue) || !value.equals((rValue = (ResourceWrapperSymbolicValue)constrainedValue.getKey()).dependent)) continue;
                this.programState = this.programState.addConstraint(rValue, constrainedValue.getValue().withStatus(Status.CLOSED));
            }
        }

        private void closeArguments(Arguments arguments) {
            this.programState.peekValues(arguments.size()).forEach(this::closeResource);
        }

        private void closeResource(@Nullable SymbolicValue target) {
            ObjectConstraint<Status> oConstraint;
            if (target != null && (oConstraint = this.programState.getConstraintWithStatus(target, Status.OPENED)) != null) {
                this.programState = this.programState.addConstraint(target.wrappedValue(), oConstraint.withStatus(Status.CLOSED));
            }
        }
    }

    private static class WrappedValueFactory
    implements SymbolicValueFactory {
        private final SymbolicValue value;

        WrappedValueFactory(SymbolicValue value) {
            this.value = value;
        }

        @Override
        public SymbolicValue createSymbolicValue(int counter) {
            return new ResourceWrapperSymbolicValue(counter, this.value);
        }
    }

    private static class ResourceWrapperSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue dependent;

        ResourceWrapperSymbolicValue(int id, SymbolicValue dependent) {
            super(id);
            this.dependent = dependent;
        }

        @Override
        public SymbolicValue wrappedValue() {
            return this.dependent.wrappedValue();
        }
    }

    private static enum Status implements ObjectConstraint.Status
    {
        OPENED,
        CLOSED;

    }
}

