/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.xml;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.java.xml.XmlCheckUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.squidbridge.api.AnalysisException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlCheckContextImpl
implements XmlCheckContext {
    private final Document document;
    private final File file;
    private final SonarComponents sonarComponents;
    private final XPath xPath;

    public XmlCheckContextImpl(Document document, File file, XPath xPath, SonarComponents sonarComponents) {
        this.document = document;
        this.file = file;
        this.xPath = xPath;
        this.sonarComponents = sonarComponents;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public XPathExpression compile(String expression) {
        try {
            return this.xPath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new AnalysisException("Unable to compile XPath expression '" + expression + "'", (Throwable)e);
        }
    }

    @Override
    public Iterable<Node> evaluateOnDocument(XPathExpression expression) {
        return this.evaluate(expression, this.document);
    }

    @Override
    public Iterable<Node> evaluate(XPathExpression expression, Node node) {
        try {
            NodeList nodeList = (NodeList)expression.evaluate(node, XPathConstants.NODESET);
            if (nodeList.getLength() == 0) {
                return ImmutableList.of();
            }
            return new NodeListIterable(nodeList);
        }
        catch (XPathExpressionException e) {
            throw new AnalysisException("Unable to evaluate XPath expression", (Throwable)e);
        }
    }

    @Override
    public void reportIssueOnFile(JavaCheck check, String message) {
        this.reportIssue(check, -1, message);
    }

    @Override
    public void reportIssue(JavaCheck check, int line, String message) {
        this.sonarComponents.addIssue(this.file, check, line, message, null);
    }

    @Override
    public void reportIssue(JavaCheck check, Node node, String message) {
        Integer line = XmlCheckUtils.nodeLine(node);
        if (line != null) {
            this.reportIssue(check, line, message);
        }
    }

    @Override
    public void reportIssue(JavaCheck check, Node node, String message, Iterable<XmlCheckContext.XmlDocumentLocation> secondary) {
        this.reportIssue(check, node, message, secondary, null);
    }

    @Override
    public void reportIssue(JavaCheck check, Node node, String message, Iterable<XmlCheckContext.XmlDocumentLocation> secondary, @Nullable Integer cost) {
        Integer line = XmlCheckUtils.nodeLine(node);
        if (line != null) {
            this.sonarComponents.reportIssue(XmlCheckContextImpl.buildAnalyzerMessage(check, message, line, secondary, cost, this.getFile()));
        }
    }

    public static AnalyzerMessage buildAnalyzerMessage(JavaCheck check, String message, Integer line, Iterable<XmlCheckContext.XmlDocumentLocation> secondary, @Nullable Integer cost, File file) {
        AnalyzerMessage analyzerMessage = new AnalyzerMessage(check, file, line, message, cost != null ? cost : 0);
        for (XmlCheckContext.XmlDocumentLocation location : secondary) {
            AnalyzerMessage secondaryLocation = XmlCheckContextImpl.getSecondaryAnalyzerMessage(check, file, location);
            if (secondaryLocation == null) continue;
            analyzerMessage.flows.add(Collections.singletonList(secondaryLocation));
        }
        return analyzerMessage;
    }

    @CheckForNull
    private static AnalyzerMessage getSecondaryAnalyzerMessage(JavaCheck check, File file, XmlCheckContext.XmlDocumentLocation location) {
        Integer startLine = XmlCheckUtils.nodeLine(location.node);
        if (startLine == null) {
            return null;
        }
        AnalyzerMessage.TextSpan ts = new AnalyzerMessage.TextSpan(startLine, 0, startLine, 0);
        return new AnalyzerMessage(check, file, ts, location.msg, 0);
    }

    public SonarComponents getSonarComponents() {
        return this.sonarComponents;
    }

    private static class NodeListIterable
    implements Iterable<Node> {
        private final NodeList nodeList;

        public NodeListIterable(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public Iterator<Node> iterator() {
            return new NodeListIterator(this.nodeList);
        }

        private static class NodeListIterator
        implements Iterator<Node> {
            private final NodeList nodeList;
            private final int length;
            private int count = 0;

            public NodeListIterator(NodeList nodeList) {
                this.nodeList = nodeList;
                this.length = nodeList.getLength();
            }

            @Override
            public boolean hasNext() {
                return this.count < this.length;
            }

            @Override
            public Node next() {
                Node node = this.nodeList.item(this.count);
                if (node == null) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return node;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

