/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.java.AbstractJavaClasspath;
import org.sonar.squidbridge.api.AnalysisException;

public class JavaClasspath
extends AbstractJavaClasspath {
    private static final Logger LOG = Loggers.get(JavaClasspath.class);

    public JavaClasspath(Settings settings, FileSystem fs) {
        super(settings, fs, InputFile.Type.MAIN);
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            this.validateLibraries = this.fs.hasFiles(this.fs.predicates().all());
            Profiler profiler = Profiler.create((Logger)LOG).startInfo("JavaClasspath initialization");
            this.initialized = true;
            this.binaries = new ArrayList<File>(this.getFilesFromProperty("sonar.java.binaries"));
            Set<File> libraries = this.getFilesFromProperty("sonar.java.libraries");
            if (this.binaries.isEmpty() && libraries.isEmpty() && this.useDeprecatedProperties()) {
                throw new AnalysisException("sonar.binaries and sonar.libraries are not supported since version 4.0 of sonar-java-plugin, please use sonar.java.binaries and sonar.java.libraries instead");
            }
            this.elements = new ArrayList(this.binaries);
            if (libraries.isEmpty() && this.hasJavaSources()) {
                LOG.warn("Bytecode of dependencies was not provided for analysis of source files, you might end up with less precise results. Bytecode can be provided using sonar.java.libraries property");
            }
            this.elements.addAll(libraries);
            profiler.stopInfo();
        }
    }

    private boolean useDeprecatedProperties() {
        return !Strings.isNullOrEmpty((String)this.settings.getString("sonar.binaries")) && !Strings.isNullOrEmpty((String)this.settings.getString("sonar.libraries"));
    }
}

