/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.collections;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.java.collections.PStack;

final class SinglyLinkedList<E>
implements PStack<E> {
    private final E element;
    @Nullable
    private final SinglyLinkedList<E> next;
    private int hashCode;
    static final PStack EMPTY = new PStack(){

        public PStack push(Object o) {
            return new SinglyLinkedList(o);
        }

        public Object peek() {
            throw new IllegalStateException();
        }

        public PStack pop() {
            throw new IllegalStateException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public void forEach(Consumer action) {
        }

        public boolean anyMatch(Predicate predicate) {
            return false;
        }

        @Override
        public String toString() {
            return "[]";
        }
    };

    private SinglyLinkedList(E element) {
        this.element = element;
        this.next = null;
    }

    private SinglyLinkedList(E element, SinglyLinkedList<E> next) {
        this.element = element;
        this.next = next;
    }

    @Override
    public PStack<E> push(E e) {
        Preconditions.checkNotNull(e);
        return new SinglyLinkedList<E>(e, this);
    }

    @Override
    public E peek() {
        return this.element;
    }

    @Override
    public PStack<E> pop() {
        return this.next == null ? EMPTY : this.next;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void forEach(Consumer<E> action) {
        SinglyLinkedList<E> c = this;
        while (c != null) {
            action.accept(c.element);
            c = c.next;
        }
    }

    @Override
    public boolean anyMatch(Predicate<E> predicate) {
        SinglyLinkedList<E> c = this;
        while (c != null) {
            if (predicate.test(c.element)) {
                return true;
            }
            c = c.next;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.next == null ? 0 : this.next.hashCode();
            this.hashCode = this.hashCode * 31 + this.element.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        this.forEach(e -> sb.append(e.toString()).append(", "));
        sb.delete(sb.length() - 2, sb.length());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SinglyLinkedList) {
            SinglyLinkedList other = (SinglyLinkedList)obj;
            return this.element.equals(other.element) && Objects.equals(this.next, other.next);
        }
        return false;
    }
}

