/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;

public class TypeSubstitution {
    private LinkedHashMap<TypeVariableJavaType, JavaType> substitutions = Maps.newLinkedHashMap();

    public TypeSubstitution() {
    }

    public TypeSubstitution(TypeSubstitution typeSubstitution) {
        this.substitutions = Maps.newLinkedHashMap(typeSubstitution.substitutions);
    }

    @CheckForNull
    public JavaType substitutedType(JavaType javaType) {
        return this.substitutions.get(javaType);
    }

    public List<TypeVariableJavaType> typeVariables() {
        return Lists.newArrayList(this.substitutions.keySet());
    }

    public List<Map.Entry<TypeVariableJavaType, JavaType>> substitutionEntries() {
        return Lists.newArrayList(this.substitutions.entrySet());
    }

    public List<JavaType> substitutedTypes() {
        return Lists.newArrayList(this.substitutions.values());
    }

    public TypeSubstitution add(TypeVariableJavaType typeVariableType, JavaType javaType) {
        this.substitutions.put(typeVariableType, javaType.isPrimitive() ? javaType.primitiveWrapperType() : javaType);
        return this;
    }

    public int size() {
        return this.substitutions.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeSubstitution newSubstitution = (TypeSubstitution)obj;
        return this.substitutions.equals(newSubstitution.substitutions) && this.substitutionEntries().equals(newSubstitution.substitutionEntries());
    }

    public int hashCode() {
        return this.substitutionEntries().hashCode();
    }

    public boolean isIdentity() {
        return this.substitutionEntries().stream().noneMatch(s -> s.getKey() != s.getValue());
    }

    public TypeSubstitution combine(TypeSubstitution source) {
        TypeSubstitution result = new TypeSubstitution();
        for (Map.Entry<TypeVariableJavaType, JavaType> substitution : this.substitutionEntries()) {
            TypeVariableJavaType typeVar = substitution.getKey();
            JavaType targetType = TypeSubstitution.filterWildcard(substitution.getValue());
            JavaType substitutedType = source.substitutedType(typeVar);
            if (substitutedType == null || targetType == substitutedType) {
                result.add(typeVar, targetType);
                continue;
            }
            substitutedType = TypeSubstitution.filterWildcard(substitutedType);
            if (targetType.isArray() && substitutedType.isArray()) {
                targetType = TypeSubstitution.elementType(targetType);
                substitutedType = TypeSubstitution.elementType(substitutedType);
            }
            if (targetType.isTagged(15)) {
                result.add((TypeVariableJavaType)targetType, substitutedType);
                continue;
            }
            if (targetType.isParameterized() && substitutedType.isParameterized()) {
                TypeSubstitution combined = ((ParametrizedTypeJavaType)targetType).typeSubstitution.combine(((ParametrizedTypeJavaType)substitutedType).typeSubstitution);
                result.substitutions.putAll(combined.substitutions);
                continue;
            }
            result.add(typeVar, targetType);
        }
        return result;
    }

    private static JavaType filterWildcard(JavaType javaType) {
        if (javaType.isTagged(16)) {
            return ((WildCardType)javaType).bound;
        }
        return javaType;
    }

    private static JavaType elementType(JavaType javaType) {
        if (javaType.isArray()) {
            return TypeSubstitution.elementType(((ArrayJavaType)javaType).elementType);
        }
        return javaType;
    }
}

