/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.MethodYield;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class FlowComputation {
    private final Predicate<Constraint> addToFlow;
    private final Predicate<Constraint> terminateTraversal;
    private final List<JavaFileScannerContext.Location> flow = new ArrayList<JavaFileScannerContext.Location>();
    private final SymbolicValue symbolicValue;
    private final Set<ExplodedGraph.Node> visited = new HashSet<ExplodedGraph.Node>();

    private FlowComputation(@Nullable SymbolicValue symbolicValue, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal) {
        this.addToFlow = addToFlow;
        this.terminateTraversal = terminateTraversal;
        this.symbolicValue = symbolicValue;
    }

    public static List<JavaFileScannerContext.Location> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal) {
        return FlowComputation.flow(currentNode, currentVal, constraint -> true);
    }

    public static List<JavaFileScannerContext.Location> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, Predicate<Constraint> addToFlow) {
        return FlowComputation.flow(currentNode, currentVal, addToFlow, c -> false);
    }

    public static List<JavaFileScannerContext.Location> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal) {
        FlowComputation flowComputation = new FlowComputation(currentVal, addToFlow, terminateTraversal);
        Symbol trackSymbol = currentNode.programState.getLastEvaluated();
        if (currentVal instanceof BinarySymbolicValue) {
            Set<JavaFileScannerContext.Location> binSVFlow = flowComputation.flowFromBinarySV(currentNode, (BinarySymbolicValue)currentVal, trackSymbol);
            flowComputation.flow.addAll(binSVFlow);
        }
        flowComputation.run(currentNode, trackSymbol);
        return flowComputation.flow;
    }

    private Set<JavaFileScannerContext.Location> flowFromBinarySV(ExplodedGraph.Node currentNode, BinarySymbolicValue binarySV, Symbol trackSymbol) {
        LinkedHashSet<JavaFileScannerContext.Location> binSVFlow = new LinkedHashSet<JavaFileScannerContext.Location>();
        FlowComputation left = this.fork(binarySV.getLeftOp());
        left.run(currentNode.parent(), trackSymbol);
        binSVFlow.addAll(left.flow);
        FlowComputation right = this.fork(binarySV.getRightOp());
        right.run(currentNode.parent(), trackSymbol);
        binSVFlow.addAll(right.flow);
        return binSVFlow;
    }

    private FlowComputation fork(SymbolicValue symbolicValue) {
        return new FlowComputation(symbolicValue, this.addToFlow, this.terminateTraversal);
    }

    private void run(@Nullable ExplodedGraph.Node node, @Nullable Symbol trackSymbol) {
        ArrayDeque<NodeSymbol> workList = new ArrayDeque<NodeSymbol>();
        workList.add(new NodeSymbol(node, trackSymbol));
        while (!workList.isEmpty()) {
            NodeSymbol nodeSymbol = (NodeSymbol)workList.pop();
            ExplodedGraph.Node currentNode = nodeSymbol.node;
            if (currentNode == null || this.visited.contains(currentNode)) continue;
            this.visited.add(currentNode);
            Symbol newTrackSymbol = nodeSymbol.trackSymbol;
            if (currentNode.programPoint.syntaxTree() != null) {
                newTrackSymbol = this.addFlowFromLearnedSymbols(currentNode, newTrackSymbol);
                Stream<Constraint> learnedConstraints = this.addFlowFromLearnedConstraints(currentNode);
                if (learnedConstraints.anyMatch(this.terminateTraversal)) continue;
            }
            for (ExplodedGraph.Node parent : currentNode.getParents()) {
                workList.push(new NodeSymbol(parent, newTrackSymbol));
            }
        }
    }

    private Stream<Constraint> addFlowFromLearnedConstraints(ExplodedGraph.Node currentNode) {
        ExplodedGraph.Node parent = currentNode.parent();
        if (parent == null) {
            return Stream.empty();
        }
        return currentNode.getLearnedConstraints().stream().filter(lc -> lc.getSv().equals(this.symbolicValue)).map(ExplodedGraph.Node.LearnedConstraint::getConstraint).peek(lc -> this.learnedConstraintFlow((Constraint)lc, currentNode, parent).forEach(this.flow::add));
    }

    private Stream<JavaFileScannerContext.Location> learnedConstraintFlow(@Nullable Constraint learnedConstraint, ExplodedGraph.Node currentNode, ExplodedGraph.Node parent) {
        if (learnedConstraint == null || !this.addToFlow.test(learnedConstraint)) {
            return Stream.empty();
        }
        Tree nodeTree = parent.programPoint.syntaxTree();
        if (FlowComputation.isMethodInvocationNode(parent)) {
            return this.methodInvocationFlow(learnedConstraint, currentNode, parent);
        }
        if (nodeTree.is(Tree.Kind.NEW_CLASS)) {
            return Stream.of(FlowComputation.location(parent, String.format("Constructor implies '%s'.", learnedConstraint.valueAsString())));
        }
        String name = SyntaxTreeNameFinder.getName(nodeTree);
        String message = name == null ? learnedConstraint.valueAsString() : String.format("Implies '%s' is %s.", name, learnedConstraint.valueAsString());
        return Stream.of(FlowComputation.location(parent, message));
    }

    private Stream<JavaFileScannerContext.Location> methodInvocationFlow(Constraint learnedConstraint, ExplodedGraph.Node currentNode, ExplodedGraph.Node parent) {
        MethodYield selectedMethodYield;
        int argIdx;
        SymbolicValue methodIdentifier;
        MethodInvocationTree mit = (MethodInvocationTree)parent.programPoint.syntaxTree();
        Stream.Builder<JavaFileScannerContext.Location> flowBuilder = Stream.builder();
        if (currentNode.programState.peekValue() == this.symbolicValue) {
            flowBuilder.add(FlowComputation.location(parent, String.format("'%s()' returns %s.", mit.symbol().name(), learnedConstraint.valueAsString())));
        }
        if ((methodIdentifier = parent.programState.peekValues(mit.arguments().size() + 1).get(mit.arguments().size())) == this.symbolicValue) {
            flowBuilder.add(FlowComputation.location(parent, "..."));
        }
        if ((argIdx = FlowComputation.correspondingArgumentIndex(this.symbolicValue, parent)) != -1) {
            ExpressionTree argTree = (ExpressionTree)mit.arguments().get(argIdx);
            String message = String.format("Implies '%s' is %s.", SyntaxTreeNameFinder.getName(argTree), learnedConstraint.valueAsString());
            flowBuilder.add(new JavaFileScannerContext.Location(message, argTree));
        }
        if ((selectedMethodYield = currentNode.selectedMethodYield(parent)) != null) {
            selectedMethodYield.flow(argIdx).forEach(flowBuilder::add);
        }
        return flowBuilder.build();
    }

    private static boolean isMethodInvocationNode(ExplodedGraph.Node node) {
        ExplodedGraph.ProgramPoint pp = node.programPoint;
        if (pp.i < pp.block.elements().size()) {
            Tree tree = pp.block.elements().get(pp.i);
            return tree.is(Tree.Kind.METHOD_INVOCATION);
        }
        return false;
    }

    private static int correspondingArgumentIndex(SymbolicValue candidate, ExplodedGraph.Node invocationNode) {
        MethodInvocationTree mit = (MethodInvocationTree)invocationNode.programPoint.syntaxTree();
        List<SymbolicValue> arguments = FlowComputation.argumentsUsedForMethodInvocation(invocationNode, mit);
        return arguments.indexOf(candidate);
    }

    private static List<SymbolicValue> argumentsUsedForMethodInvocation(ExplodedGraph.Node invocationNode, MethodInvocationTree mit) {
        List<SymbolicValue> values = invocationNode.programState.peekValues(mit.arguments().size());
        return Lists.reverse(values);
    }

    @Nullable
    private Symbol addFlowFromLearnedSymbols(ExplodedGraph.Node currentNode, @Nullable Symbol trackSymbol) {
        ExplodedGraph.Node parent = currentNode.parent();
        if (trackSymbol == null || parent == null) {
            return null;
        }
        Optional<ExplodedGraph.Node.LearnedValue> learnedValue = currentNode.getLearnedSymbols().stream().filter(lv -> lv.getSymbol().equals(trackSymbol)).findFirst();
        if (learnedValue.isPresent()) {
            ExplodedGraph.Node.LearnedValue lv2 = learnedValue.get();
            Constraint constraint = parent.programState.getConstraint(lv2.getSv());
            String message = constraint == null ? "..." : String.format("'%s' is assigned %s.", lv2.getSymbol().name(), constraint.valueAsString());
            this.flow.add(FlowComputation.location(parent, message));
            return parent.programState.getLastEvaluated();
        }
        return trackSymbol;
    }

    private static JavaFileScannerContext.Location location(ExplodedGraph.Node node, String message) {
        return new JavaFileScannerContext.Location(message, node.programPoint.syntaxTree());
    }

    public static Set<List<JavaFileScannerContext.Location>> singleton(String msg, Tree tree) {
        return ImmutableSet.of((Object)ImmutableList.of((Object)new JavaFileScannerContext.Location(msg, tree)));
    }

    private static class NodeSymbol {
        final ExplodedGraph.Node node;
        final Symbol trackSymbol;

        public NodeSymbol(@Nullable ExplodedGraph.Node node, @Nullable Symbol trackSymbol) {
            this.node = node;
            this.trackSymbol = trackSymbol;
        }
    }
}

